/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Iterator;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.boadapters.TransactionBatchBO;
import nl.ibs.fac.boadapters.ValuationBO;
import nl.ibs.fac.bp.DepreciationProposalBP;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Transaction;
import nl.ibs.fac.db.TransactionBatch;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.DBData;

public class OMO002
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;
    TransactionBatch transactionBatch = null;
    Company company;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        DBData dbData = this.invokeAdapter.getDBData();
        String companyId = this.invokeAdapter.getCompanyId();
        if (companyId == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        TransactionBatch depreciationProposal = DepreciationProposalBP.getCurrentDepreciationBatch(dbData, companyId);
        if (depreciationProposal == null) {
            throw new IllegalArgumentException("Er is voor bedrijf " + companyId + " geen voorlopig afschrijvingsvoorstel aanwezig !");
        }
        Iterator iterator = TransactionBO.getTransactions(depreciationProposal).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Het afschrijvingsvoorstel voor bedrijf " + companyId + " is leeg !");
        }
        Transaction transaction = null;
        String cora = null;
        String prvCora = null;
        String assetId = null;
        String prvAssetId = null;
        int ap = -1;
        int prvAp = -1;
        int numberOfDepreciatedPeriods = 0;
        BigDecimal totalDepreciated = new BigDecimal("0");
        this.company = this.invokeAdapter.getCompany();
        while (iterator.hasNext()) {
            transaction = (Transaction)iterator.next();
            cora = transaction.getCora();
            assetId = transaction.getAssetId();
            ap = transaction.getAccountingPrinciple();
            if (prvAssetId == null) {
                prvCora = cora;
                prvAssetId = assetId;
                prvAp = ap;
            }
            if (!prvCora.equals(cora) || !prvAssetId.equals(assetId) || prvAp != ap) {
                this.createTransaction(dbData, companyId, prvCora, prvAssetId, prvAp, numberOfDepreciatedPeriods, totalDepreciated);
                prvCora = cora;
                prvAssetId = assetId;
                prvAp = ap;
                numberOfDepreciatedPeriods = 0;
                totalDepreciated = new BigDecimal("0");
            }
            if (transaction.getAmount2().doubleValue() == 0.0 && transaction.getReasonCode() != 21) continue;
            ++numberOfDepreciatedPeriods;
            totalDepreciated = totalDepreciated.add(transaction.getAmount2());
        }
        this.createTransaction(dbData, companyId, prvCora, prvAssetId, prvAp, numberOfDepreciatedPeriods, totalDepreciated);
        if (this.transactionBatch != null) {
            this.transactionBatch.setProcessedBy("FACSYSBEH");
            this.transactionBatch.setProcessingDate(this.transactionBatch.getCreationDate());
            this.transactionBatch.setState(2);
        }
    }

    private void createTransaction(DBData dbData, String companyId, String prvCora, String prvAssetId, int prvAp, int numberOfDepreciatedPeriods, BigDecimal totalDepreciated) throws Exception {
        if (numberOfDepreciatedPeriods == 0 && totalDepreciated.doubleValue() == 0.0) {
            return;
        }
        Valuation valuation = (Valuation)ValuationBO.get(dbData, companyId, prvCora, prvAssetId, prvAp)[0];
        valuation.setNumberOfDepreciatedPeriods(valuation.getNumberOfDepreciatedPeriods() + numberOfDepreciatedPeriods);
        if (totalDepreciated.doubleValue() == 0.0) {
            return;
        }
        valuation.setPostedDepreciationBalance(valuation.getPostedDepreciationBalance().add(totalDepreciated));
        if (valuation.getInterestCalculationMethod() == 2) {
            valuation.setPreviousBookvalueBalance(valuation.getPreviousBookvalueBalance().subtract(totalDepreciated));
        }
        if (this.transactionBatch == null) {
            this.transactionBatch = (TransactionBatch)TransactionBatchBO.create(dbData, companyId, "FACSYSBEH", 0)[0];
        }
        Asset asset = (Asset)AssetBO.get(this.company, prvAssetId, false)[0];
        Transaction transaction = (Transaction)TransactionBO.create(dbData, companyId, 0, 1, "Afschr. aug t/m dec 2010", prvCora, prvAssetId, prvAp, 3, 90, 2010, 12, 2010, 12, new BigDecimal(0), totalDepreciated, new BigDecimal(0), null, asset.getFinDimId1(), asset.getFinDimId2(), asset.getFinDimId3(), asset.getFinDimId4(), asset.getFinDimId5(), 0, 0, this.transactionBatch.getBatchId(), "FACSYSBEH", asset.getTypeId())[0];
        transaction.setState(1);
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

