/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.boadapters.AssetBO;
import nl.ibs.fac.boadapters.TransactionBO;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.Company;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class UpdatePBVBalance
implements FACUserTool {
    FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        Company company = this.invokeAdapter.getCompany();
        if (company == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        String companyId = company.getId();
        ExecutableQuery query = QueryFactory.create(Valuation.class);
        query.setFilter("companyId = '" + companyId + "' AND " + "interestCalculationMethod" + " = " + 1);
        int numberOfPeriods = company.retrieveNumberOfPeriods();
        for (Valuation valuation : ValuationManagerFactory.getInstance(company.getDBData()).getCollection(query)) {
            BigDecimal bookValue;
            BigDecimal[] values;
            Asset asset = (Asset)AssetBO.get(company, valuation.getAssetId(), false)[0];
            if (valuation.getLastDepreciationBookYear() == 0) {
                values = TransactionBO.calculateAcquisitionValue(asset, valuation.getAccountingPrinciple(), valuation.getStartDepreciationBookYear(), 1);
                bookValue = values[0].subtract(values[1]);
            } else {
                values = TransactionBO.calculateAcquisitionValue(asset, valuation.getAccountingPrinciple(), valuation.getLastDepreciationBookYear(), 1);
                bookValue = values[0].subtract(values[1]);
                bookValue = bookValue.subtract(TransactionBO.calculateDepreciatedTotal(asset, valuation.getAccountingPrinciple(), valuation.getLastDepreciationBookYear() - 1, numberOfPeriods)[0]);
            }
            valuation.setPreviousBookvalueBalance(bookValue);
        }
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return false;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

