/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.fac.usertool;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import nl.ibs.esp.uiobjects.FieldGroup;
import nl.ibs.fac.db.Asset;
import nl.ibs.fac.db.AssetManagerFactory;
import nl.ibs.fac.db.Valuation;
import nl.ibs.fac.db.ValuationManager;
import nl.ibs.fac.db.ValuationManagerFactory;
import nl.ibs.fac.usertool.FACUserTool;
import nl.ibs.fac.usertool.FACUserToolInvokeAdapter;
import nl.ibs.jsql.ExecutableQuery;
import nl.ibs.jsql.QueryFactory;

public class ValuationInterest
implements FACUserTool {
    private FACUserToolInvokeAdapter invokeAdapter;

    @Override
    public void execute(String[] parameterValues) throws Exception {
        String companyId = this.invokeAdapter.getCompanyId();
        if (companyId == null) {
            throw new IllegalArgumentException("Er is geen bedrijf actief !");
        }
        String typeId = parameterValues[0];
        BigDecimal interest = new BigDecimal(parameterValues[1]);
        ExecutableQuery query = QueryFactory.create(Asset.class);
        query.setFilter("companyId = '" + companyId + "' AND " + "typeId" + " = '" + typeId + "'");
        Collection assets = AssetManagerFactory.getInstance(this.invokeAdapter.getCompany().getDBData()).getCollection(query);
        for (Asset asset : assets) {
            Valuation valuation = ValuationInterest.getFirstValuation(asset);
            valuation.setInterestCalculationMethod(2);
            valuation.setInterestPercentage(interest);
        }
    }

    private static Valuation getFirstValuation(Asset asset) throws Exception {
        ExecutableQuery query = QueryFactory.create(Valuation.class);
        query.setCacheable(true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        String filter = ValuationInterest.addFilterTerm(null, "companyId = ?_companyId");
        parameters.put("_companyId", asset.getCompanyId());
        filter = ValuationInterest.addFilterTerm(filter, "cora = ?_cora");
        parameters.put("_cora", asset.getCora());
        filter = ValuationInterest.addFilterTerm(filter, "assetId = ?_assetId");
        parameters.put("_assetId", asset.getId());
        query.setFilter(filter);
        query.setParameters(parameters);
        ValuationManager manager = ValuationManagerFactory.getInstance(asset.getDBData());
        return manager.getFirstObject(query);
    }

    private static String addFilterTerm(String filter, String term) throws Exception {
        if (term == null || term.length() == 0) {
            return filter;
        }
        if (filter != null) {
            return filter + " AND " + term;
        }
        return term;
    }

    @Override
    public String[] getParameterDescriptions() throws Exception {
        return new String[]{"Type", "Rentepercentage"};
    }

    @Override
    public FieldGroup getFieldGroup() throws Exception {
        return null;
    }

    @Override
    public String[] validate() throws Exception {
        return null;
    }

    @Override
    public String getProgramDescription() throws Exception {
        return null;
    }

    @Override
    public String getCompletionMessage() throws Exception {
        return null;
    }

    @Override
    public boolean getAS400WriterNeeded() throws Exception {
        return true;
    }

    @Override
    public void setInvoker(FACUserToolInvokeAdapter invokeAdapter) throws Exception {
        this.invokeAdapter = invokeAdapter;
    }
}

