/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.BusinessObject_Impl;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBTransactionListener;
import nl.ibs.jsql.impl.ArrayListImpl;
import nl.ibs.jsql.impl.ConcurrentHashMap;
import nl.ibs.jsql.sql.ConnectionPool;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.DBMapping;
import nl.ibs.jsql.sql.ORMapping;

public class AtomicDBTransaction
extends ConnectionPool {
    private static long hits = 0L;
    private static long lookups = 0L;
    private static boolean printCacheStatistics = DBConfig.getPrintCacheStatistics();
    private static Map tableNames = new ConcurrentHashMap();
    private boolean available = true;
    private int isolationlevel;
    private int prev_isolationlevel;
    private DBConnectionPool pool;
    private DBConnection con;
    private HashSet listeners;
    private Map queryCache;
    private BusinessObject_Impl deferedForUpdate;
    private boolean fullClearCacheOnUpdate = true;

    public void useQueryResultCache(boolean cache) {
        this.queryCache = cache ? (this.fullClearCacheOnUpdate ? new HashMap() : new ResultCache()) : null;
    }

    public void fullClearResultCacheOnUpdates(boolean fullClearCaches) {
        if (this.fullClearCacheOnUpdate != fullClearCaches && this.queryCache != null) {
            this.queryCache = fullClearCaches ? new HashMap() : new ResultCache();
        }
        this.fullClearCacheOnUpdate = fullClearCaches;
    }

    public void clearQueryResultCache() {
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    public void clearQueryResultCache(BusinessObject_Impl impl) {
        if (this.queryCache != null && !this.queryCache.isEmpty()) {
            if (this.fullClearCacheOnUpdate || impl == null) {
                this.queryCache.clear();
            } else {
                String tableName = (String)tableNames.get(impl);
                if (tableName == null) {
                    tableName = impl.getPersistenceMetaData().getTableName(this);
                    tableNames.put(impl, tableName);
                }
                if (tableName == null || tableName.length() == 0) {
                    this.queryCache.clear();
                } else {
                    ((ResultCache)this.queryCache).removeKeysContaining(tableName);
                }
            }
        }
    }

    public Object getCachedResult(String query) throws Exception {
        Object c;
        if (this.deferedForUpdate != null) {
            this.deferedForUpdate.save();
            this.deferedForUpdate = null;
        }
        Object v0 = c = this.queryCache == null ? null : this.queryCache.get(query);
        if (printCacheStatistics && this.queryCache != null) {
            long l = hits = c != null ? hits + 1L : hits;
            if (++lookups % 50L == 0L) {
                Log.info((String)("Hit ratio: " + hits * 100L / lookups + "%. (" + lookups + " lookups," + hits + " hits)"));
            }
        }
        if (c instanceof ArrayListImpl) {
            return ((ArrayListImpl)c).getBaseCopy();
        }
        return c;
    }

    public void setCachedResult(String query, Object result) {
        if (this.queryCache != null) {
            if (result instanceof ArrayListImpl) {
                ((ArrayListImpl)result).fixate();
            }
            this.queryCache.put(query, result);
        }
    }

    public AtomicDBTransaction(DBData data) {
        this.pool = DBConnectionPool.getInstance(data);
        this.init();
    }

    public boolean isActive() {
        return this.con != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        try {
            if (!this.pool.getDatabaseMetaData().supportsTransactions()) {
                this.pool = null;
                throw new Exception("msg-transactions-not-suported-by-database");
            }
            this.isolationlevel = this.pool.getDatabaseMetaData().getDefaultTransactionIsolation();
            if (this.isolationlevel != 0) {
                if (this.isolationlevel >= 2) return;
                if (!this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(2)) return;
                this.isolationlevel = 2;
                return;
            }
            if (this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(2)) {
                this.isolationlevel = 2;
                return;
            }
            if (this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(4)) {
                this.isolationlevel = 4;
                return;
            }
            if (this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(8)) {
                this.isolationlevel = 8;
                return;
            }
            if (this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(1)) {
                this.isolationlevel = 1;
                return;
            }
            this.pool = null;
            throw new Exception("msg-transactions-not-upurted-by-database");
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public ConnectionProvider getConnectionProvider() {
        return this.pool;
    }

    public boolean readUncommitted() {
        return this.isolationlevel <= 1;
    }

    public void setTransActionIsolationLevel(int level) throws Exception {
        if (!this.pool.getDatabaseMetaData().supportsTransactionIsolationLevel(level)) {
            throw new Exception("msg-requested-transaction-isolation-level-not-supported-by-database");
        }
        if (level == 0) {
            throw new Exception("msg-requested-transaction-isolation-level-none-is-not-permitted-here");
        }
        this.isolationlevel = level;
    }

    public int getTransActionIsolationLevel() {
        return this.isolationlevel;
    }

    void begin() throws Exception {
        if (this.deferedForUpdate != null) {
            throw new Exception("Bug in JSQL; deferedForUpdate not null at beginning of transaction");
        }
        if (this.con == null) {
            try {
                this.con = this.pool.getConnection();
                this.prev_isolationlevel = this.con.getConnection().getTransactionIsolation();
                if (this.prev_isolationlevel != this.isolationlevel) {
                    this.con.getConnection().setTransactionIsolation(this.isolationlevel);
                }
                this.con.getConnection().setAutoCommit(false);
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    public DBConnection getConnectionForUpdate() throws Exception {
        return this.getConnectionForUpdate(null);
    }

    public DBConnection getConnectionForUpdate(BusinessObject_Impl impl) throws Exception {
        this.clearQueryResultCache(impl);
        if (this.deferedForUpdate != null) {
            if (this.deferedForUpdate == impl) {
                this.deferedForUpdate = null;
            } else {
                this.setDeferedForUpdate(null);
            }
        }
        return this.internalGetConnection();
    }

    protected synchronized DBConnection internalGetConnection() throws Exception {
        if (this.con == null) {
            throw new Exception("msg-tried-to-use-a-transaction-connection-that-was-not-yet-active");
        }
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.available = false;
        return this.con;
    }

    @Override
    public synchronized DBConnection getConnection() throws Exception {
        if (this.deferedForUpdate != null) {
            this.deferedForUpdate.save();
            this.deferedForUpdate = null;
        }
        if (this.con != null) {
            return this.internalGetConnection();
        }
        return this.pool.getConnection();
    }

    @Override
    public synchronized void returnConnection(DBConnection connection) throws Exception {
        try {
            if (connection == null) {
                throw new Exception("msg-returned-connection-was-null-check-programm");
            }
            if (!connection.isConnected()) {
                throw new Exception("msg-returned-connection-lost-connection-check-programm");
            }
            if (this.con != connection) {
                this.pool.returnConnection(connection);
            } else {
                this.available = true;
                this.notifyAll();
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    public void addListener(DBTransactionListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    void rollback() throws Exception {
        this.rollback(true);
    }

    void rollback(boolean includeBOFields) throws Exception {
        this.deferedForUpdate = null;
        if (this.con != null) {
            try {
                this.con.getConnection().rollback();
                try {
                    this.con.getConnection().setAutoCommit(true);
                    this.con.getConnection().setTransactionIsolation(this.prev_isolationlevel);
                    this.pool.returnConnection(this.con);
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                    Log.error((String)"mdg-could-not-return-connection-to-pool-on-rollback-connection-will-be-closed");
                    this.con.getConnection().close();
                }
                this.con = null;
                if (this.listeners != null && !this.listeners.isEmpty()) {
                    Iterator it = this.listeners.iterator();
                    while (it.hasNext()) {
                        ((DBTransactionListener)it.next()).rollback(includeBOFields);
                    }
                    this.listeners.clear();
                }
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    void commit() throws Exception {
        this.setDeferedForUpdate(null);
        if (this.con != null) {
            try {
                this.con.getConnection().commit();
                this.con.getConnection().setAutoCommit(true);
                this.con.getConnection().setTransactionIsolation(this.prev_isolationlevel);
                this.pool.returnConnection(this.con);
                this.con = null;
                if (this.listeners != null && !this.listeners.isEmpty()) {
                    Iterator it = this.listeners.iterator();
                    while (it.hasNext()) {
                        ((DBTransactionListener)it.next()).commit();
                    }
                    this.listeners.clear();
                }
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    void forceClose() {
        Log.warn((String)"msg-only-call-forseClose-if-rollback-has-thrown-an-exception-as-a-last-resort!");
        if (this.con != null) {
            try {
                if (!this.con.getConnection().getAutoCommit()) {
                    this.con.getConnection().rollback();
                }
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
            try {
                this.con.getConnection().close();
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
            this.con = null;
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((DBTransactionListener)it.next()).rollback(true);
                }
                catch (Exception e) {
                    Log.error((String)e.getMessage());
                    e.printStackTrace();
                }
            }
            this.listeners.clear();
        }
    }

    @Override
    public String getPrefix() {
        return this.pool.getPrefix();
    }

    @Override
    public String getDriver() {
        return this.pool.getDriver();
    }

    @Override
    public DBMapping getDBMapping() {
        return this.pool.getDBMapping();
    }

    @Override
    public ORMapping getORMapping() {
        return this.pool.getORMapping();
    }

    @Override
    public boolean sameDataBase(ConnectionPool otherPool) {
        return this.getDBId() == otherPool.getDBId();
    }

    @Override
    public int getDBId() {
        return this.pool.getDBId();
    }

    @Override
    public DBData getDBData() {
        return this.pool.getDBData();
    }

    @Override
    public String getSearchStringEscape() {
        return this.pool.getSearchStringEscape();
    }

    protected void finalize() throws Throwable {
        if (this.con != null) {
            try {
                if (this.con.getConnection() != null) {
                    try {
                        this.con.getConnection().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.con = null;
                if (this.listeners != null && !this.listeners.isEmpty()) {
                    Iterator it = this.listeners.iterator();
                    while (it.hasNext()) {
                        ((DBTransactionListener)it.next()).rollback(true);
                    }
                    this.listeners.clear();
                }
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void setDeferedForUpdate(BusinessObject_Impl impl) throws Exception {
        if (this.deferedForUpdate == null) {
            this.deferedForUpdate = impl;
        } else if (this.deferedForUpdate != impl) {
            BusinessObject_Impl updatable = this.deferedForUpdate;
            this.deferedForUpdate = null;
            updatable.save();
            this.deferedForUpdate = impl;
        }
    }

    private static final class ResultCache
    extends HashMap {
        ArrayList keys = new ArrayList(64);

        public ResultCache() {
            super(64);
        }

        @Override
        public Object put(Object key, Object value) {
            this.keys.add(key);
            return super.put(key, value);
        }

        public void removeKeysContaining(String substring) {
            for (int i = 0; i < this.keys.size(); ++i) {
                String key = (String)this.keys.get(i);
                if (key.indexOf(substring) < 0) continue;
                super.remove(key);
                this.keys.remove(i--);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.keys.clear();
        }
    }
}

