/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.io.Serializable;
import java.util.HashMap;
import nl.ibs.jsql.DBConfig;

public class DBData
implements Serializable {
    private static InheritableThreadLocal currentDBDataMap = new InheritableThreadLocal(){

        @Override
        protected Object initialValue() {
            return new HashMap(1);
        }
    };
    private int hashCode;
    protected String application = "";
    protected String name = "";
    protected String url = "";
    protected String driver = "";
    protected String user = "";
    protected String password = "";
    protected String schema = "";
    protected boolean autoCreateTables = true;
    protected boolean autoAddColumns = true;
    protected boolean autoModifyColumns = false;
    protected boolean autoDropColumns = false;

    private DBData(String application) {
        this(application, null, DBConfig.getJDBCDriver(application), DBConfig.getURL(application), DBConfig.getSchema(application), DBConfig.getUser(application), DBConfig.getPassword(application));
    }

    public static DBData getDefaultDBData(String application) {
        DBData dbData = (DBData)((HashMap)currentDBDataMap.get()).get(application);
        if (dbData == null) {
            dbData = new DBData(application);
            ((HashMap)currentDBDataMap.get()).put(application, dbData);
        }
        return dbData;
    }

    static void setDefaultDBData(DBData defaultDBD) {
        ((HashMap)currentDBDataMap.get()).put(defaultDBD.getApplication(), defaultDBD);
    }

    protected DBData(String _application, String _name, String _driver, String _url, String _schema, String _user, String _password) {
        if (_application == null || _application.trim().length() == 0) {
            throw new RuntimeException("Tried to create a DBData object without providing a name. This is not allowed");
        }
        this.application = _application;
        this.name = _name;
        this.url = _url;
        this.driver = _driver;
        this.schema = _schema;
        this.user = _user;
        this.password = _password;
        String dbidString = _driver + _url + _schema + _user;
        if (this.name == null || this.name.trim().equals("")) {
            this.name = dbidString;
        }
        this.hashCode = dbidString.hashCode();
        this.autoCreateTables = DBConfig.getAutoCreateTables(this.application);
        this.autoAddColumns = DBConfig.getAutoAddColumns(this.application);
        this.autoModifyColumns = DBConfig.getAutoModifyColumns(this.application);
        this.autoDropColumns = DBConfig.getAutoDropColumns(this.application);
    }

    protected DBData(String application, String _name, String _driver, String _url, String _schema, String _user, String _password, boolean _autoCreateTables, boolean _autoAddColumns) {
        this(application, _name, _driver, _url, _schema, _user, _password);
        this.autoCreateTables = _autoCreateTables;
        this.autoAddColumns = _autoAddColumns;
    }

    protected DBData(String application, String _name, String _driver, String _url, String _schema, String _user, String _password, boolean _autoCreateTables, boolean _autoAddColumns, boolean _autoModifyColumns, boolean _autoDropColumns) {
        this(application, _name, _driver, _url, _schema, _user, _password, _autoCreateTables, _autoAddColumns);
        this.autoModifyColumns = _autoModifyColumns;
        this.autoDropColumns = _autoDropColumns;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getAutoCreateTables() {
        return this.autoCreateTables;
    }

    public boolean getAutoAddColumns() {
        return this.autoAddColumns;
    }

    public boolean getAutoModifyColumns() {
        return this.autoModifyColumns;
    }

    public boolean getAutoDropColumns() {
        return this.autoDropColumns;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int getDBId() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBData)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String getApplication() {
        return this.application;
    }
}

