/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.ConnectionLifeCycleListener;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBTransaction;
import nl.ibs.jsql.exception.InvalidStateException;
import nl.ibs.jsql.sql.ConnectionPool;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.DBConnectionPool;

public class DBPersistenceManager {
    private static ArrayList connectionLyfeCycleListeners = new ArrayList(1);
    private static ConnectionPool defaultPool;
    private static Cache applicationCache;
    private static boolean cachingOff;
    private static boolean transactionCaching;
    private static InheritableThreadLocal activeTransaction;

    public static void setDefaultDataBase(DBData dbdata) {
        DBData.setDefaultDBData(dbdata);
    }

    public static ConnectionProvider getConnectionProvider(String application) throws Exception {
        return DBPersistenceManager.getConnectionProvider(DBData.getDefaultDBData(application));
    }

    public static ConnectionProvider getConnectionProvider(DBData data) throws Exception {
        DBTransaction transaction = (DBTransaction)activeTransaction.get();
        if (transaction == null) {
            return DBConnectionPool.getInstance(data);
        }
        return transaction.getConnectionProvider(data);
    }

    public static void setTransaction(DBTransaction tx) {
        activeTransaction.set(tx);
    }

    public static DBTransaction getCurrentTransaction() {
        DBTransaction tx = (DBTransaction)activeTransaction.get();
        if (tx == null) {
            tx = new DBTransaction();
            DBPersistenceManager.setTransaction(tx);
        }
        return tx;
    }

    public static DBTransaction getTransaction() {
        return (DBTransaction)activeTransaction.get();
    }

    public static DBTransaction getNewTransaction() throws InvalidStateException {
        DBTransaction tx = (DBTransaction)activeTransaction.get();
        if (tx != null && tx.isActive()) {
            throw new InvalidStateException("Invoked DBTransaction.getNewTransaction() while current transaction still active. First submit or rollback current transaction before invoking getNewTransaction()");
        }
        tx = new DBTransaction();
        DBPersistenceManager.setTransaction(tx);
        return tx;
    }

    public static Cache getCache() {
        DBTransaction tx;
        if (cachingOff) {
            return null;
        }
        if (applicationCache != null) {
            return applicationCache;
        }
        if (transactionCaching && (tx = (DBTransaction)activeTransaction.get()) != null) {
            return tx.getCache();
        }
        return null;
    }

    public static void setApplicationCache(Cache cache) throws Exception {
        if (applicationCache == null) {
            throw new Exception("Caching is not activated for application, check your configuration!!");
        }
        applicationCache = cache;
    }

    public static Object cache(Object o) {
        Cache cache;
        if (o == null || (cache = DBPersistenceManager.getCache()) == null) {
            return o;
        }
        return cache.cache(o);
    }

    public static void removeFromCache(Collection c) {
        Cache cache;
        if (c != null && !c.isEmpty() && (cache = DBPersistenceManager.getCache()) != null) {
            cache.removeFromCache(c);
        }
    }

    public static void removeFromCache(Object o) {
        Cache cache;
        if (o != null && (cache = DBPersistenceManager.getCache()) != null) {
            cache.removeFromCache(o);
        }
    }

    public static void invokeConnectionLifeCycleListenersPostConnected(Connection con) throws Exception {
        for (int i = 0; i < connectionLyfeCycleListeners.size(); ++i) {
            ((ConnectionLifeCycleListener)connectionLyfeCycleListeners.get(i)).postConnect(con);
        }
    }

    public static void invokeConnectionLifeCycleListenersPreDisconnected(Connection con) throws Exception {
        for (int i = 0; i < connectionLyfeCycleListeners.size(); ++i) {
            ((ConnectionLifeCycleListener)connectionLyfeCycleListeners.get(i)).preDisconnect(con);
        }
    }

    public static void add(ConnectionLifeCycleListener listener) {
        if (listener != null && !connectionLyfeCycleListeners.contains(listener)) {
            connectionLyfeCycleListeners.add(listener);
        }
    }

    static {
        applicationCache = null;
        cachingOff = "off".equals(DBConfig.getCaching());
        transactionCaching = "transaction".equals(DBConfig.getCaching());
        activeTransaction = new InheritableThreadLocal();
        if ("application".equals(DBConfig.getCaching())) {
            applicationCache = new Cache();
        }
    }
}

