/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql;

import java.util.HashMap;
import java.util.Iterator;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.AtomicDBTransaction;
import nl.ibs.jsql.Cache;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.DBData;
import nl.ibs.jsql.DBPersistenceManager;
import nl.ibs.jsql.sql.ConnectionProvider;

public class DBTransaction {
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    public static final int TRANSACTION_NONE = 0;
    public static final boolean defaultUseQueryResultCache = DBConfig.getCacheQueryResults();
    private int isolationlevel;
    private HashMap applicationTransactions;
    private boolean useQueryResultCache = defaultUseQueryResultCache;
    private boolean clearCachesOnTransActionStart = true;
    private boolean fullClearResultCachesOnUpdate = true;
    private Cache transactionCache;
    private boolean active;

    public void useQueryResultCache(boolean cache) {
        if (cache != this.useQueryResultCache && !this.applicationTransactions.isEmpty()) {
            Iterator atomicTransactions = this.applicationTransactions.values().iterator();
            while (atomicTransactions.hasNext()) {
                for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                    cache = false;
                    if (false) {
                        at.clearQueryResultCache();
                    }
                    at.useQueryResultCache(cache);
                }
            }
        }
        this.useQueryResultCache = cache;
    }

    public void clearTransactionCachesOnTransactionStart(boolean clearCaches) {
        this.clearCachesOnTransActionStart = clearCaches;
    }

    public void fullClearResultCacheOnUpdates(boolean fullClearCaches) {
        if (this.fullClearResultCachesOnUpdate != fullClearCaches && !this.applicationTransactions.isEmpty()) {
            Iterator atomicTransactions = this.applicationTransactions.values().iterator();
            while (atomicTransactions.hasNext()) {
                for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                    at.fullClearResultCacheOnUpdates(fullClearCaches);
                }
            }
        }
        this.fullClearResultCachesOnUpdate = fullClearCaches;
    }

    public DBTransaction() {
        this.applicationTransactions = new HashMap(1);
        if ("transaction".equals(DBConfig.getCaching())) {
            this.transactionCache = new Cache();
        }
        this.isolationlevel = 2;
    }

    public boolean isActive() {
        return this.active;
    }

    public ConnectionProvider getConnectionProvider(DBData dbdata) throws Exception {
        AtomicDBTransaction at;
        HashMap<DBData, AtomicDBTransaction> atomicTransactions = (HashMap<DBData, AtomicDBTransaction>)this.applicationTransactions.get(dbdata.getApplication());
        if (atomicTransactions == null) {
            atomicTransactions = new HashMap<DBData, AtomicDBTransaction>(1);
            this.applicationTransactions.put(dbdata.getApplication(), atomicTransactions);
        }
        if ((at = (AtomicDBTransaction)atomicTransactions.get(dbdata)) == null) {
            at = new AtomicDBTransaction(dbdata);
            at.setTransActionIsolationLevel(this.isolationlevel);
            at.useQueryResultCache(this.useQueryResultCache);
            at.fullClearResultCacheOnUpdates(this.fullClearResultCachesOnUpdate);
            if (this.active) {
                at.begin();
            }
            atomicTransactions.put(dbdata, at);
        }
        return at;
    }

    public boolean readUncommitted() {
        return this.isolationlevel <= 1;
    }

    public void setTransActionIsolationLevel(int level) throws Exception {
        if (this.active) {
            throw new Exception("msg-tried-to-change-transaction-isoloation-level-on-started-transction");
        }
        this.isolationlevel = level;
    }

    public int getTransActionIsolationLevel() {
        return this.isolationlevel;
    }

    public void begin() throws Exception {
        Iterator atomicTransactions;
        DBTransaction activeTransaction = DBPersistenceManager.getTransaction();
        if (activeTransaction == null) {
            DBPersistenceManager.setTransaction(this);
        } else if (activeTransaction != this) {
            throw new Exception("Other transaction already set on this thread");
        }
        if (this.clearCachesOnTransActionStart) {
            if (this.transactionCache != null) {
                this.transactionCache.clear();
            }
            if (this.useQueryResultCache) {
                atomicTransactions = this.applicationTransactions.values().iterator();
                while (atomicTransactions.hasNext()) {
                    for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                        at.clearQueryResultCache();
                    }
                }
            }
        }
        if (!this.active) {
            try {
                atomicTransactions = this.applicationTransactions.values().iterator();
                while (atomicTransactions.hasNext()) {
                    for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                        at.useQueryResultCache(this.useQueryResultCache);
                        at.fullClearResultCacheOnUpdates(this.fullClearResultCachesOnUpdate);
                        at.begin();
                    }
                }
                this.active = true;
            }
            catch (Exception e) {
                Iterator atomicTransactions2 = this.applicationTransactions.values().iterator();
                while (atomicTransactions2.hasNext()) {
                    for (AtomicDBTransaction at : ((HashMap)atomicTransactions2.next()).values()) {
                        at.clearQueryResultCache();
                        if (!at.isActive()) continue;
                        at.forceClose();
                    }
                }
                this.active = false;
                throw e;
            }
        } else {
            throw new Exception("msg-tried-to-begin-a-transaction-that-was-allready-active");
        }
    }

    public void rollback() throws Exception {
        this.rollback(true);
    }

    public void rollback(boolean includeBOFields) throws Exception {
        Iterator atomicTransactions = this.applicationTransactions.values().iterator();
        while (atomicTransactions.hasNext()) {
            for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                at.rollback(includeBOFields);
            }
        }
        DBPersistenceManager.setTransaction(null);
        this.active = false;
    }

    public void commit() throws Exception {
        Iterator atomicTransactions = this.applicationTransactions.values().iterator();
        while (atomicTransactions.hasNext()) {
            for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                at.commit();
            }
        }
        DBPersistenceManager.setTransaction(null);
        this.active = false;
    }

    public void forceClose() {
        Log.warn((String)"msg-only-call-forse-close-if-a-call-to-rollback-has-thrown-an-exception-as-last-resort");
        Iterator atomicTransactions = this.applicationTransactions.values().iterator();
        while (atomicTransactions.hasNext()) {
            for (AtomicDBTransaction at : ((HashMap)atomicTransactions.next()).values()) {
                at.forceClose();
            }
        }
        DBPersistenceManager.setTransaction(null);
        this.active = false;
    }

    public Cache getCache() {
        return this.active ? this.transactionCache : null;
    }

    protected void finalize() throws Throwable {
        this.applicationTransactions.clear();
    }
}

