/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;
import nl.ibs.jeelog.Log;

public class BeanTableModelImpl
extends AbstractTableModel {
    ClassLoader classLoader;
    ArrayList objects;
    Class _class;
    ArrayList columns = new ArrayList();
    ArrayList getters = new ArrayList();
    ArrayList setters = new ArrayList();
    ArrayList headers = new ArrayList();
    ArrayList editable = new ArrayList();
    ArrayList classes = new ArrayList();

    public BeanTableModelImpl(ArrayList list, Class _class) {
        this.objects = (ArrayList)list.clone();
        this._class = _class;
        this.classLoader = _class.getClassLoader();
    }

    public BeanTableModelImpl(Collection collection, Class _class) {
        this.objects = new ArrayList(collection);
        this._class = _class;
        this.classLoader = _class.getClassLoader();
    }

    public BeanTableModelImpl(ListIterator iterator, Class _class) {
        this.objects = new ArrayList();
        while (iterator.hasPrevious()) {
            iterator.previous();
        }
        while (iterator.hasNext()) {
            this.objects.add(iterator.next());
        }
        this._class = _class;
        this.classLoader = _class.getClassLoader();
    }

    public void addColumn(String columnName) {
        this.addColumn(columnName, null, false);
    }

    public void addColumn(String columnName, String columnHeader) {
        this.addColumn(columnName, columnHeader, false);
    }

    public void addColumn(String columnName, String columnHeader, boolean editable) {
        this.setColumn(columnName, columnHeader, this.columns.size(), editable);
    }

    public void addColumn(String columnName, boolean editable) {
        this.setColumn(columnName, null, this.columns.size(), editable);
    }

    public void setColumn(String columnName, int index) {
        this.setColumn(columnName, null, index, false);
    }

    public void setColumn(String columnName, int index, boolean editable) {
        this.setColumn(columnName, null, index, editable);
    }

    public void setColumn(String columnName, String columnHeader, int index, boolean _editable) {
        try {
            columnName = columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
            if (columnHeader == null) {
                columnHeader = this.translateFromCamelBack(columnName);
            }
            Method get = null;
            Method set = null;
            try {
                get = this._class.getMethod("get" + columnName, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (get != null) {
                    set = this._class.getMethod("set" + columnName, get.getReturnType());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (get != null && Modifier.isPublic(get.getModifiers())) {
                Log.debug((String)("Add column " + columnName));
                this.columns.add(index, columnName);
                this.getters.add(index, get);
                this.setters.add(index, set);
                this.headers.add(index, columnHeader);
                this.editable.add(index, new Boolean(_editable && set != null && Modifier.isPublic(set.getModifiers())));
                Class<Object> columnClass = get.getReturnType();
                if (columnClass.isPrimitive()) {
                    if (columnClass == Boolean.TYPE) {
                        columnClass = Boolean.class;
                    } else if (columnClass == Integer.TYPE) {
                        columnClass = Integer.class;
                    } else if (columnClass == Long.TYPE) {
                        columnClass = Long.class;
                    } else if (columnClass == Float.TYPE) {
                        columnClass = Float.class;
                    } else if (columnClass == Double.TYPE) {
                        columnClass = Double.class;
                    } else if (columnClass == Character.TYPE) {
                        columnClass = Character.class;
                    } else if (columnClass == Byte.TYPE) {
                        columnClass = Byte.class;
                    } else if (columnClass == Short.TYPE) {
                        columnClass = Short.class;
                    }
                }
                this.classes.add(index, columnClass);
            } else {
                Log.error((String)("Column " + columnName + " not valid"));
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public void setAllColumns(boolean editable) {
        this.removeAllColumns();
        Field[] fields = this._class.getDeclaredFields();
        for (int x = 0; x < fields.length; ++x) {
            if (!Modifier.isPrivate(fields[x].getModifiers()) || Modifier.isStatic(fields[x].getModifiers())) continue;
            this.addColumn(fields[x].getName(), editable);
        }
    }

    public void removeAllColumns() {
        this.columns.clear();
        this.getters.clear();
        this.setters.clear();
        this.headers.clear();
        this.editable.clear();
        this.classes.clear();
    }

    public void removeColumn(String columnName) {
        try {
            columnName = columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
            this.removeColumn(this.columns.indexOf(columnName));
        }
        catch (Exception e) {
            Log.debug((String)(" column " + columnName + "  not found!"));
        }
    }

    public void removeColumn(int index) {
        if (index != -1 && index < this.columns.size()) {
            this.columns.remove(index);
            this.getters.remove(index);
            this.setters.remove(index);
            this.headers.remove(index);
            this.editable.remove(index);
            this.classes.remove(index);
        }
    }

    public void setEditable(int column, boolean _editable) {
        this.editable.set(column, new Boolean(_editable && this.setters.get(column) != null && Modifier.isPublic(((Method)this.setters.get(column)).getModifiers())));
    }

    public void setEditable(String columnName, boolean _editable) {
        columnName = columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
        try {
            this.editable.set(this.columns.indexOf(columnName), new Boolean(_editable));
        }
        catch (Exception e) {
            Log.error((String)(" column " + columnName + "  not found"));
        }
    }

    public void setColumnHeader(String columnName, String columnHeader) {
        columnName = columnName.substring(0, 1).toUpperCase() + columnName.substring(1);
        try {
            this.headers.set(this.columns.indexOf(columnName), columnHeader);
        }
        catch (Exception e) {
            Log.error((String)(" column " + columnName + "  not found"));
        }
    }

    public void replaceColumnHeader(String oldValue, String newValue) {
        try {
            this.headers.set(this.columns.indexOf(oldValue), newValue);
        }
        catch (Exception e) {
            Log.error((String)("Header " + oldValue + "  not found"));
        }
    }

    public void setColumnHeader(int index, String header) {
        this.headers.set(index, header);
    }

    public ArrayList getHeaderNames() {
        return (ArrayList)this.headers.clone();
    }

    public ArrayList getColumnNames() {
        return (ArrayList)this.columns.clone();
    }

    public int getColumnIndexOf(String columnName) {
        return this.columns.indexOf(columnName);
    }

    public int getHeaderIndexOf(String headerName) {
        return this.headers.indexOf(headerName);
    }

    public String translateFromCamelBack(String in) {
        StringBuffer buffer = new StringBuffer();
        boolean prevIsLower = false;
        for (int x = 0; x < in.length(); ++x) {
            char c = in.charAt(x);
            if (x == 0 && Character.isLetter(c)) {
                buffer.append(Character.toUpperCase(c));
                continue;
            }
            if (x == 0) {
                buffer.append(c);
                continue;
            }
            if (!Character.isLetter(c)) {
                buffer.append(c);
                continue;
            }
            if (Character.isLowerCase(c)) {
                prevIsLower = true;
                buffer.append(c);
                continue;
            }
            if (prevIsLower) {
                prevIsLower = false;
                buffer.append(" ");
                if (x + 1 < in.length() && Character.isUpperCase(in.charAt(x + 1))) {
                    buffer.append(c);
                    continue;
                }
                buffer.append(Character.toLowerCase(c));
                continue;
            }
            if (x + 1 < in.length() && Character.isLowerCase(in.charAt(x + 1))) {
                buffer.append(" " + Character.toLowerCase(c));
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (Log.debug()) {
            Log.debug((String)("getValue (" + row + " x " + column + ")"));
        }
        try {
            return ((Method)this.getters.get(column)).invoke(this.objects.get(row), new Object[0]);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
            Log.debug((String)"returning null!");
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (((Boolean)this.editable.get(column)).booleanValue()) {
            try {
                ((Method)this.setters.get(column)).invoke(this.objects.get(row), value);
            }
            catch (Exception e) {
                Log.error((String)e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return (Boolean)this.editable.get(column);
    }

    public Class getColumnClass(int column) {
        return (Class)this.classes.get(column);
    }

    @Override
    public String getColumnName(int column) {
        return (String)this.headers.get(column);
    }
}

