/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.ListIterator;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.PersistenceMetaData;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;

public abstract class BusinessObjectManager
implements Serializable {
    public static final short RETURN_FIRST_OBJECT = 0;
    public static final short RETURN_COLLECTION = -1;
    public static final short RETURN_LISTITERATOR = -2;
    public static final short RETURN_DOCUMENT = -3;
    public static final short RETURN_DOCUMENT_FRAGMENT = -4;
    public static final short RETURN_DOCUMENT_FRAGMENT_ARRAYLIST = -5;
    private static Hashtable getInstanceMethods = new Hashtable();

    public Object processResultSet(ResultSet resultSet, short instruction) throws Exception {
        switch (instruction) {
            case 0: {
                if (resultSet.next()) {
                    return this.getBusinessObject(resultSet);
                }
                return null;
            }
            case -1: {
                return this.getCollection(resultSet);
            }
            case -2: {
                return this.getListIterator(resultSet);
            }
            case -3: {
                return this.getDocument(resultSet);
            }
            case -4: {
                return this.getDocumentFragment(resultSet);
            }
            case -5: {
                return this.getDocumentFragmentArrayList(resultSet);
            }
        }
        throw new Exception("Unknown instruction");
    }

    public String getClassName(ResultSet rs) throws Exception {
        ConnectionProvider provider = this.getConnectionProvider();
        PersistenceMetaData pmd = this.getPersistenceMetaData();
        return rs.getString(pmd.getFieldName("className", provider));
    }

    public abstract ConnectionProvider getConnectionProvider() throws Exception;

    public abstract PersistenceMetaData getPersistenceMetaData();

    protected abstract Object getBusinessObject(ResultSet var1) throws Exception;

    protected abstract Collection getCollection(ResultSet var1) throws Exception;

    protected abstract ListIterator getListIterator(ResultSet var1) throws Exception;

    protected abstract Document getDocument(ResultSet var1) throws Exception;

    protected abstract DocumentFragment getDocumentFragment(ResultSet var1) throws Exception;

    protected abstract ArrayList getDocumentFragmentArrayList(ResultSet var1) throws Exception;

    public Object getBusinessObjectForView(ResultSet rs) throws Exception {
        return this.getBusinessObject(rs);
    }

    public Collection getCollectionForView(ResultSet rs) throws Exception {
        return this.getCollection(rs);
    }

    public ListIterator getListIteratorForView(ResultSet rs) throws Exception {
        return this.getListIterator(rs);
    }

    public Document getDocumentForView(ResultSet resultSet) throws Exception {
        return this.getDocument(resultSet);
    }

    public DocumentFragment getDocumentFragmentForView(ResultSet resultSet) throws Exception {
        return this.getDocumentFragment(resultSet);
    }

    public ArrayList getDocumentFragmentArrayListForView(ResultSet resultSet) throws Exception {
        return this.getDocumentFragmentArrayList(resultSet);
    }

    public static BusinessObjectManager getBusinessObjectManager(Class businessObjectClass) throws Exception {
        Method getInstanceMethod = (Method)getInstanceMethods.get(businessObjectClass);
        if (getInstanceMethod == null) {
            if (businessObjectClass == null) {
                throw new IllegalArgumentException("class supplied as parameter is null!");
            }
            String name = BusinessObjectManager.getNameBusinessObjectManagerClass(businessObjectClass);
            Class<?> bomClass = businessObjectClass.getClassLoader().loadClass(name);
            getInstanceMethod = bomClass.getDeclaredMethod("getInstance", null);
            getInstanceMethods.put(businessObjectClass, getInstanceMethod);
        }
        return (BusinessObjectManager)getInstanceMethod.invoke(null, (Object[])null);
    }

    private static String getNameBusinessObjectManagerClass(Class _class) throws Exception {
        String prefix = "impl.";
        String postFix = "Manager_Impl";
        String fqClassName = _class.getName();
        String packageName = "";
        String className = "";
        int i = fqClassName.lastIndexOf(46);
        if (i < 0) {
            className = fqClassName;
        } else {
            packageName = fqClassName.substring(0, i + 1);
            className = fqClassName.substring(i + 1);
        }
        if (!packageName.endsWith(prefix)) {
            packageName = packageName + prefix;
        }
        if (className.endsWith("_Impl")) {
            className = className.substring(0, className.lastIndexOf("_Impl"));
        }
        return packageName + className + postFix;
    }
}

