/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import nl.ibs.jeelog.Log;

public class ColumnDefinition {
    public String tableCatalog;
    public String tableSchema;
    public String tableName;
    public String columnName;
    public int sqlType = -1;
    public String typeName;
    public int columnSize = -1;
    public int decimalDigits = -1;
    public int numberPreciousRadix = -1;
    public int nullable;
    public String remarks;
    public String columnDefinition = "";
    public int charOctetLength = -1;
    public int ordinalPosition = -1;
    public String isNullable;
    public String scopeCatlog;
    public String scopeSchema;
    public String scopeTable;
    public short sourceDataType = (short)-1;

    public static HashMap getColumnDefinitions(String schemaPattern, String tablePattern, DatabaseMetaData meta) {
        return ColumnDefinition.getColumnDefinitions(schemaPattern, tablePattern, "_%", meta);
    }

    public static HashMap getColumnDefinitions(String schemaPattern, String tablePattern, String columnPattern, DatabaseMetaData meta) {
        HashMap<String, ColumnDefinition> map = new HashMap<String, ColumnDefinition>();
        ResultSet rs = null;
        String _schemaPattern = schemaPattern == null || schemaPattern.equals("") ? null : schemaPattern;
        try {
            rs = meta.getColumns(null, _schemaPattern, tablePattern, columnPattern);
            while (rs.next()) {
                ColumnDefinition definition = new ColumnDefinition(rs, meta);
                map.put(definition.columnName.toUpperCase(), definition);
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    private ColumnDefinition(ResultSet rs, DatabaseMetaData meta) {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int z = rsmd.getColumnCount();
            if (z < 1) {
                return;
            }
            this.tableCatalog = rs.getString(1);
            if (z < 2) {
                return;
            }
            this.tableSchema = rs.getString(2);
            if (z < 3) {
                return;
            }
            this.tableName = rs.getString(3);
            if (z < 4) {
                return;
            }
            this.columnName = rs.getString(4);
            if (z < 5) {
                return;
            }
            this.sqlType = rs.getInt(5);
            if (z < 6) {
                return;
            }
            this.typeName = rs.getString(6);
            if (z < 7) {
                return;
            }
            this.columnSize = rs.getInt(7);
            if (z < 9) {
                return;
            }
            this.decimalDigits = rs.getInt(9);
            if (z < 10) {
                return;
            }
            this.numberPreciousRadix = rs.getInt(10);
            if (z < 11) {
                return;
            }
            this.nullable = rs.getInt(11);
            if (z < 12) {
                return;
            }
            this.remarks = rs.getString(12);
            if (z < 13) {
                return;
            }
            this.columnDefinition = rs.getString(13);
            if (z < 16) {
                return;
            }
            this.charOctetLength = rs.getInt(16);
            if (z < 17) {
                return;
            }
            this.ordinalPosition = rs.getInt(17);
            if (z < 18) {
                return;
            }
            this.isNullable = rs.getString(18);
            if (z < 19) {
                return;
            }
            this.scopeCatlog = rs.getString(19);
            if (z < 20) {
                return;
            }
            this.scopeSchema = rs.getString(20);
            if (z < 21) {
                return;
            }
            this.scopeTable = rs.getString(21);
            if (z >= 22) {
                this.sourceDataType = rs.getShort(22);
            }
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }
}

