/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import nl.ibs.jeelog.Log;
import nl.ibs.jsql.DBConfig;
import nl.ibs.jsql.sql.AssociationMetaData;
import nl.ibs.jsql.sql.BusinessObjectManager;
import nl.ibs.jsql.sql.ColumnDefinition;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.CustomDBManagerImpl;
import nl.ibs.jsql.sql.DBConnection;
import nl.ibs.jsql.sql.DBConnectionPool;
import nl.ibs.jsql.sql.ForeignKeyColumnPair;
import nl.ibs.jsql.sql.ForeignKeyDefinition;
import nl.ibs.jsql.sql.IndexColumn;
import nl.ibs.jsql.sql.IndexDefinition;
import nl.ibs.jsql.sql.PersistenceMetaData;
import nl.ibs.jsql.sql.PrimaryKeyColumn;
import nl.ibs.jsql.sql.PrimaryKeyDefinition;
import nl.ibs.jsql.sql.TableDefinition;

public abstract class DBManager {
    private static final String META_DATA_TABLE = "JSQLMTDT";
    private static final String BO_PACKAGE_COLUMN = "BO_PACKAGE";
    private static final String BO_NAME_COLUMN = "BO_NAME";
    private static final String BO_ATTRIBUTE_COLUMN = "BO_ATTRIBUTE";
    private static final String TABLE_COLUMN = "TABLE_NAME";
    private static final String COLUMN_COLUMN = "COLUMN_NAME";
    private static final String SQL_DEFINITION_COLUMN = "SQL_DEFINITION";
    private static final String DEFAULT_VALUE_COLUMN = "DEFAULT_VALUE";
    private static final String EXTENTION_COLUMN = "EXTENTION";
    private static final String DESCRIPTION_COLUMN = "DESCRIPTION";
    private static final String VERSION_DATA_TABLE = "JSQLVRSN";
    private static final String VERSION_COLUMN = "VERSION_NUMBER";
    private static final String TYPE_COLUMN = "VERSION_TYPE";
    private static final String CURRENT_JSQL_VERSION = "1.8.001";
    private static final String JSQL_VERSION = "JSQL_VERSION";
    private static final String APPLICATION_VERSION = "APPLICATION_VERSION";
    private static final String CHGJOB = "CALL QSYS.QCMDEXC('CHGJOB INQMSGRPY(*SYSRPYL)',0000000026.00000)";
    private static boolean debug = Log.debug();
    private static HashMap applicationDBManagers = new HashMap(1);
    private DBConnectionPool pool;
    private DatabaseMetaData meta;
    private String prefix;
    private HashMap tableDefinitions;
    private HashMap tableNameLists;
    private String db_jsql_version;
    private String db_application_version;
    private boolean readyToDropColumns = false;
    private boolean readyToModifyColumns = false;
    private boolean initialized = true;
    private boolean preConverted = true;
    private boolean postConverted = true;
    private boolean finalized = true;

    public static DBManager getDBManager(String applicationName) throws Exception {
        String subClassName = (String)applicationDBManagers.get(applicationName);
        if (subClassName == null) {
            subClassName = DBConfig.getDBManager(applicationName);
            if (subClassName == null) {
                throw new Exception("No DBManager provided for application: " + applicationName);
            }
            applicationDBManagers.put(applicationName, subClassName);
        }
        return DBManager.getInstance(subClassName);
    }

    private static DBManager getInstance(String subclass) throws Exception {
        if (subclass == null || subclass.trim().length() == 0 || subclass.trim().equals(DBManager.class.getName())) {
            return new CustomDBManagerImpl();
        }
        Class<?> clss = DBManager.class.getClassLoader().loadClass(subclass);
        return (DBManager)clss.getConstructor(null).newInstance(null);
    }

    public abstract PersistenceMetaData[] getPersistenceMetaDataArray();

    public void init(DBConnectionPool pool) throws RuntimeException {
        try {
            pool.getDBMapping();
            this.pool = pool;
            this.prefix = pool.getPrefix();
            this.updateMetaData();
            this.db_jsql_version = this.getDBJSQLVersion();
            this.db_application_version = this.getDBApplicationVersion();
            this.logMetaData();
            this.initializeDataBase();
        }
        catch (Throwable e) {
            String message = "initialization failed" + (e.getMessage() == null ? "!" : ": " + e.getMessage());
            Log.error((String)(message + " See previous messages!"));
            e.printStackTrace();
            throw new RuntimeException(message);
        }
    }

    public void initializeDataBase() throws Exception {
        try {
            if (this.skipConversion(this.pool)) {
                return;
            }
            this.internalInitializeBeforeConversion();
            if (this.schemaExists() && this.getCurrentJSQLVersion() == null) {
                this.removeForeignKeys();
                this.removePrimaryKeys();
                this.removeIndexes();
            }
            this.initialise(this.pool);
            if (this.initialized) {
                this.updateMetaData();
            }
            if (this.checkSchema()) {
                this.updateMetaData();
            }
            this.removeRedundantConstraintsAndIndexes();
            this.preConvert(this.pool);
            if (this.preConverted) {
                this.updateMetaData();
            }
            this.updateTables();
            this.postConvert(this.pool);
            if (this.postConverted) {
                this.updateMetaData();
            }
            this.updateConstraintsAndIndexes();
            this.removeRedundantColumns();
            this.persistMetaData();
            this.finalize(this.pool);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    protected boolean skipConversion(DBConnectionPool pool) throws Exception {
        return false;
    }

    protected void initialise(DBConnectionPool pool) throws Exception {
        this.initialized = false;
    }

    protected void preConvert(DBConnectionPool pool) throws Exception {
        this.preConverted = false;
    }

    protected void postConvert(DBConnectionPool pool) throws Exception {
        this.postConverted = false;
    }

    protected void finalize(DBConnectionPool pool) throws Exception {
        this.finalized = false;
    }

    protected String getNewDataBaseVersion() {
        return this.getCurrentDataBaseVersion();
    }

    protected void removeIndexes() throws Exception {
        this.removeIndexes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIndexes(Class[] businessObjectClasses) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        List tableNames = businessObjectClasses == null ? null : this.getTableNameList(businessObjectClasses, true);
        DBConnection connection = this.pool.getConnection();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                TableDefinition td = (TableDefinition)tdIterator.next();
                if (tableNames != null && !tableNames.contains(td.getTableName().trim().toUpperCase())) continue;
                changed = this.removeIndexes(connection, changed, td);
            }
        }
        finally {
            this.pool.returnConnection(connection);
            if (changed) {
                this.updateMetaData();
            }
        }
    }

    protected final boolean removeIndexes(DBConnection connection, boolean changed, TableDefinition td) throws Exception {
        Log.info((String)("Start remove all named indexes on " + td.getTableName()));
        for (IndexDefinition id : td.getIndexDefinitions().values()) {
            String indexName = id.getIndexName();
            if (indexName == null || indexName.startsWith("JSQL_FK") || indexName.startsWith("JSQL_PK")) continue;
            String fullTableName = this.getQualifiedName(id.getTableSchema(), id.getTableName());
            String fullIndexName = this.getQualifiedName(id.getTableSchema(), indexName);
            if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP INDEX " + fullIndexName, connection)) {
                throw new Error("Failed to remove index " + indexName + " from table " + fullTableName + ".");
            }
            Log.info((String)("Removed index " + indexName + " from table " + fullTableName + "."));
            changed = true;
        }
        return changed;
    }

    protected void removeForeignKeys() throws Exception {
        this.removeForeignKeys(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeForeignKeys(Class[] businessObjectClasses) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        List tableNames = businessObjectClasses == null ? null : this.getTableNameList(businessObjectClasses, true);
        DBConnection connection = this.pool.getConnection();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                TableDefinition td = (TableDefinition)tdIterator.next();
                if (tableNames != null && !tableNames.contains(td.getTableName().trim().toUpperCase())) continue;
                changed = this.removeForeignKeys(connection, changed, td);
            }
        }
        finally {
            this.pool.returnConnection(connection);
            if (changed) {
                this.updateMetaData();
            }
        }
    }

    protected final void internalInitializeBeforeConversion() throws Exception {
        if (this.schemaExists() && this.isAS400Driver()) {
            DBConnection dbcon = this.pool.getConnection();
            Connection con = dbcon.getConnection();
            String url = this.pool.getURL();
            int b1 = url.indexOf("package=");
            int b2 = url.indexOf("package library=");
            int b3 = url.indexOf("extended dynamic=true");
            if (b1 > -1 && b2 > -1 && b3 > -1) {
                int e = url.indexOf(";", b1);
                if (e == -1) {
                    e = url.length();
                }
                if (e > b1 + 14) {
                    e = b1 + 14;
                }
                String name = url.substring(b1 + 8, e);
                e = url.indexOf(";", b2);
                if (e == -1) {
                    e = url.length();
                }
                String lib = url.substring(b2 + 16, e);
                StringBuffer sb = new StringBuffer();
                sb.append("CALL QSYS.QCMDEXC('");
                String cmd = "DLTSQLPKG SQLPKG(" + lib + "/" + name + "*)";
                sb.append(cmd);
                sb.append("',");
                sb.append(DBManager.getLength(cmd));
                sb.append(".00000)");
                String result = sb.toString();
                Log.info((String)result);
                Statement stmt = con.createStatement();
                try {
                    stmt.executeUpdate(result);
                }
                catch (Exception ex) {
                    Log.error((String)ex.getMessage());
                }
                stmt.close();
            }
            this.pool.returnConnection(dbcon);
        }
    }

    private static final String getLength(String value) {
        String result = Integer.toString(value.length());
        while (result.length() < 10) {
            result = "0" + result;
        }
        return result;
    }

    private boolean removeForeignKeys(DBConnection connection, boolean changed, TableDefinition td) throws Exception, Error {
        Log.info((String)("Start removing all named foreign keys on " + td.getTableName()));
        for (ForeignKeyDefinition fkd : td.getForeignKeyDefinitions().values()) {
            String fkName = fkd.getFKName();
            if (fkName == null) continue;
            String fullTableName = this.getQualifiedName(fkd.getFKTableSchema(), fkd.getFKTableName());
            String fullForeignKeyName = this.getQualifiedName(fkd.getFKTableSchema(), fkName);
            if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP FOREIGN KEY " + fullForeignKeyName, connection)) {
                throw new Error("Failed to remove foreign key " + fullForeignKeyName + " from table " + fullTableName + ".");
            }
            Log.info((String)("Removed foreign key " + fullForeignKeyName + " from table " + fullTableName + "."));
            changed = true;
        }
        return changed;
    }

    protected void removePrimaryKeys() throws Exception {
        this.removePrimaryKeys(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePrimaryKeys(Class[] businessObjectClasses) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        List tableNames = businessObjectClasses == null ? null : this.getTableNameList(businessObjectClasses, true);
        DBConnection connection = this.pool.getConnection();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                TableDefinition td = (TableDefinition)tdIterator.next();
                if (tableNames != null && !tableNames.contains(td.getTableName().trim().toUpperCase())) continue;
                changed = this.removePrimaryKey(connection, changed, td);
            }
        }
        finally {
            if (changed) {
                this.updateMetaData();
            }
            this.pool.returnConnection(connection);
        }
    }

    private boolean removePrimaryKey(DBConnection connection, boolean changed, TableDefinition td) throws Exception, Error {
        PrimaryKeyDefinition pkd = td.getPrimaryKeyDefinition();
        if (pkd != null) {
            String fullTableName = this.getQualifiedName(pkd.getTableSchema(), pkd.getTableName());
            if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP PRIMARY KEY", connection)) {
                throw new Error("Failed to remove primary key from table " + fullTableName + ".");
            }
            Log.info((String)("Removed primary key from table " + fullTableName + "."));
            changed = true;
        }
        return changed;
    }

    public List getTableNameList(Class[] businessObjectClasses, boolean includeAssociationTables) throws Exception {
        ArrayList<String> list;
        if (this.tableNameLists == null) {
            this.tableNameLists = new HashMap();
        }
        if ((list = (ArrayList<String>)this.tableNameLists.get(businessObjectClasses)) != null) {
            return list;
        }
        list = new ArrayList<String>();
        PersistenceMetaData[] pmd = this.getPersistenceMetaDataArray(businessObjectClasses);
        for (int i = 0; i < pmd.length; ++i) {
            String tableName = pmd[i].getTableName(this.pool);
            if (tableName != null && !list.contains(tableName.trim().toUpperCase())) {
                list.add(tableName.trim().toUpperCase());
            }
            if (!includeAssociationTables) continue;
            Iterator amds = pmd[i].getAssociativeTableDefinitions(this.pool).values().iterator();
            while (amds.hasNext()) {
                tableName = ((AssociationMetaData)amds.next()).getTableName();
                if (tableName == null || list.contains(tableName.trim().toUpperCase())) continue;
                list.add(tableName.trim().toUpperCase());
            }
        }
        this.tableNameLists.put(businessObjectClasses, list);
        return list;
    }

    private PersistenceMetaData[] getPersistenceMetaDataArray(Class[] businessObjectClasses) throws Exception {
        ArrayList<PersistenceMetaData> list = new ArrayList<PersistenceMetaData>();
        if (businessObjectClasses != null) {
            for (int i = 0; i < businessObjectClasses.length; ++i) {
                PersistenceMetaData pmd;
                BusinessObjectManager manager = BusinessObjectManager.getBusinessObjectManager(businessObjectClasses[i]);
                if (manager == null || list.contains(pmd = manager.getPersistenceMetaData())) continue;
                list.add(pmd);
            }
        }
        return list.toArray(new PersistenceMetaData[list.size()]);
    }

    private String getQualifiedName(String schemaName, String tableName) throws Exception {
        if (schemaName == null || schemaName.trim().length() == 0) {
            return tableName;
        }
        return schemaName.trim() + this.meta.getCatalogSeparator() + tableName;
    }

    protected final void removeRedundantConstraintsAndIndexes() throws Exception {
        DBConnection con = null;
        try {
            con = this.pool.getConnection();
            this.removeRedundantForeignKeys(con);
            this.removeRedundantPrimaryKeys(con);
            this.removeRedundantIndexes(con);
        }
        finally {
            this.pool.returnConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRedundantIndexes(DBConnection connection) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                TableDefinition td = (TableDefinition)tdIterator.next();
                Log.info((String)("Start check for reduntant indexes on " + td.getTableName()));
                for (IndexDefinition id : td.getIndexDefinitions().values()) {
                    String indexName = id.getIndexName();
                    short code = 0;
                    if (indexName == null || !indexName.startsWith("JSQL_") || indexName.startsWith("JSQL_FK") || indexName.startsWith("JSQL_PK") || (code = this.isRedundant(id)) <= 0) continue;
                    String fullTableName = this.getQualifiedName(id.getTableSchema(), id.getTableName());
                    String fullIndexName = this.getQualifiedName(id.getTableSchema(), indexName);
                    if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP INDEX " + fullIndexName, connection)) {
                        throw new Error("Failed to remove " + (code == 1 ? "redundant" : "changed") + " index " + indexName + " from table " + fullTableName + ".");
                    }
                    Log.info((String)("Removed " + (code == 1 ? "redundant" : "changed") + " index " + indexName + " from table " + fullTableName + "."));
                    changed = true;
                }
            }
        }
        finally {
            if (changed) {
                this.updateMetaData();
            }
        }
    }

    private short isRedundant(IndexDefinition id) throws Exception {
        String tableName = id.getTableName();
        String indexName = id.getIndexName().trim().toUpperCase();
        PersistenceMetaData[] pmds = this.getPersistenceMetaDataArray();
        for (int i = 0; i < pmds.length; ++i) {
            String indexConstraint;
            if (!pmds[i].definesTable()) continue;
            if (pmds[i].definesTable() && tableName.equalsIgnoreCase(pmds[i].getTableName(this.pool)) && (indexConstraint = (String)pmds[i].getIndexDefinitions(this.pool).get(indexName)) != null) {
                return (short)(this.isSameIndex(id, indexConstraint) ? 0 : 2);
            }
            for (AssociationMetaData amd : pmds[i].getAssociativeTableDefinitions(this.pool).values()) {
                String indexConstraint2;
                if (!tableName.equalsIgnoreCase(amd.getTableName()) || (indexConstraint2 = (String)amd.getIndexDefinitions().get(indexName)) == null) continue;
                return (short)(this.isSameIndex(id, indexConstraint2) ? 0 : 2);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRedundantForeignKeys(DBConnection connection) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                TableDefinition td = (TableDefinition)tdIterator.next();
                Log.info((String)("Start check for reduntant foreign keys on " + td.getTableName()));
                for (ForeignKeyDefinition fkd : td.getForeignKeyDefinitions().values()) {
                    String fkName = fkd.getFKName();
                    short code = 0;
                    if (fkName == null || !fkName.startsWith("JSQL_FK") || (code = this.isRedundant(fkd)) <= 0) continue;
                    String fullTableName = this.getQualifiedName(fkd.getFKTableSchema(), fkd.getFKTableName());
                    String fullForeignKeyName = this.getQualifiedName(fkd.getFKTableSchema(), fkName);
                    if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP FOREIGN KEY " + fullForeignKeyName, connection)) {
                        throw new Error("Failed to remove " + (code == 1 ? "redundant" : "changed") + " foreign key constraint " + fullForeignKeyName + " from table " + fullTableName + ".");
                    }
                    Log.info((String)("Removed " + (code == 1 ? "redundant" : "changed") + " foreign key constraint " + fullForeignKeyName + " from table " + fullTableName + "."));
                    changed = true;
                }
            }
        }
        finally {
            if (changed) {
                this.updateMetaData();
            }
        }
    }

    private short isRedundant(ForeignKeyDefinition foreignKeyDefinition) throws Exception {
        String tableName = foreignKeyDefinition.getFKTableName();
        String fkName = foreignKeyDefinition.getFKName().trim().toUpperCase();
        PersistenceMetaData[] pmds = this.getPersistenceMetaDataArray();
        for (int i = 0; i < pmds.length; ++i) {
            String fkConstraint;
            if (!pmds[i].definesTable()) continue;
            if (tableName.equalsIgnoreCase(pmds[i].getTableName(this.pool)) && (fkConstraint = (String)pmds[i].getConstraintDefinitions(this.pool).get(fkName)) != null) {
                return (short)(this.isSameForeignKey(foreignKeyDefinition, fkConstraint) ? 0 : 2);
            }
            for (AssociationMetaData asm : pmds[i].getAssociativeTableDefinitions(this.pool).values()) {
                String fkConstraint2;
                if (!tableName.equalsIgnoreCase(asm.getTableName()) || (fkConstraint2 = (String)asm.getConstraintDefinitions().get(fkName)) == null) continue;
                return (short)(this.isSameForeignKey(foreignKeyDefinition, fkConstraint2) ? 0 : 2);
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRedundantPrimaryKeys(DBConnection connection) throws Exception {
        Iterator tdIterator = this.getTableDefinitions().values().iterator();
        boolean changed = false;
        try {
            while (tdIterator.hasNext()) {
                String pkName;
                TableDefinition td = (TableDefinition)tdIterator.next();
                Log.info((String)("Start check for redundant primary key on " + td.getTableName()));
                PrimaryKeyDefinition pkd = td.getPrimaryKeyDefinition();
                short code = 0;
                if (pkd == null || (pkName = pkd.getName()) == null || !pkName.startsWith("JSQL_PK") || (code = this.isRedundant(pkd)) <= 0) continue;
                String fullTableName = this.getQualifiedName(pkd.getTableSchema(), pkd.getTableName());
                if (!DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP PRIMARY KEY", connection)) {
                    throw new Error("Failed to remove " + (code == 1 ? "redundant" : "changed") + " primary key constraint from table " + fullTableName + ".");
                }
                Log.info((String)("Removed " + (code == 1 ? "redundant" : "changed") + " primary key constraint from table " + fullTableName + "."));
                changed = true;
            }
        }
        finally {
            if (changed) {
                this.updateMetaData();
            }
        }
    }

    private short isRedundant(PrimaryKeyDefinition primaryKeyDefinition) throws Exception {
        String tableName = primaryKeyDefinition.getTableName();
        String pkName = primaryKeyDefinition.getName().trim().toUpperCase();
        PersistenceMetaData[] pmds = this.getPersistenceMetaDataArray();
        for (int i = 0; i < pmds.length; ++i) {
            String pkConstraint;
            if (!pmds[i].definesTable()) continue;
            if (tableName.equalsIgnoreCase(pmds[i].getTableName(this.pool)) && (pkConstraint = (String)pmds[i].getConstraintDefinitions(this.pool).get(pkName)) != null) {
                return (short)(this.isSamePrimaryKey(primaryKeyDefinition, pkConstraint) ? 0 : 2);
            }
            for (AssociationMetaData amd : pmds[i].getAssociativeTableDefinitions(this.pool).values()) {
                String pkConstraint2;
                if (!tableName.equalsIgnoreCase(amd.getTableName()) || (pkConstraint2 = (String)amd.getConstraintDefinitions().get(pkName)) == null) continue;
                return (short)(this.isSamePrimaryKey(primaryKeyDefinition, pkConstraint2) ? 0 : 2);
            }
        }
        return 1;
    }

    protected final void updateMetaData() throws Exception {
        this.meta = this.pool.getDatabaseMetaData();
        this.tableDefinitions = null;
    }

    protected HashMap getTableDefinitions() throws Exception {
        if (this.tableDefinitions == null) {
            this.tableDefinitions = TableDefinition.getTableDefinitions(this.pool);
        }
        return this.tableDefinitions;
    }

    protected final void updateConstraintsAndIndexes() throws Exception {
        DBConnection con = null;
        try {
            con = this.pool.getConnection();
            this.updateIndexes(con);
            this.updatePrimaryKeys(con);
            this.updateForeignKeys(con);
        }
        finally {
            this.pool.returnConnection(con);
        }
    }

    private void updatePrimaryKeys(DBConnection connection) throws Exception {
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            PersistenceMetaData pmd = persistenceMetaData[i];
            if (!pmd.definesTable()) continue;
            String tableName = pmd.getTableName(this.pool);
            try {
                Log.info((String)("Start checking and updating primary keys on " + tableName));
                this.updatePrimaryKey(pmd, connection);
                continue;
            }
            catch (Exception e) {
                Log.error((String)("Problem adding primary key on table " + tableName + " using " + pmd.getClass().getName() + "! " + (e.getMessage() == null ? "" : "Cause: " + e.getMessage())));
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void updateForeignKeys(DBConnection connection) throws Exception {
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            PersistenceMetaData pmd = persistenceMetaData[i];
            if (!pmd.definesTable()) continue;
            String tableName = pmd.getTableName(this.pool);
            try {
                Log.info((String)("Start checking and updating foreign keys on " + tableName));
                this.updateForeignKeys(pmd, this.pool, connection);
                continue;
            }
            catch (Exception e) {
                Log.error((String)("Problem adding foreign key on table " + tableName + " using " + pmd.getClass().getName() + "! " + (e.getMessage() == null ? "" : "Cause: " + e.getMessage())));
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void updateIndexes(DBConnection connection) throws Exception {
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            PersistenceMetaData pmd = persistenceMetaData[i];
            if (!pmd.definesTable()) continue;
            String tableName = pmd.getTableName(this.pool);
            try {
                Log.info((String)("Start checking and updating indexes on " + tableName));
                this.updateIndexes(pmd, this.pool, connection);
                continue;
            }
            catch (Exception e) {
                Log.error((String)("Problem adding indexes on table " + tableName + " using " + pmd.getClass().getName() + "! " + (e.getMessage() == null ? "" : "Cause: " + e.getMessage())));
                e.printStackTrace();
                throw e;
            }
        }
    }

    public void printPrimaryKeys(DBConnection connection) throws Exception {
        for (TableDefinition definition : this.getTableDefinitions().values()) {
            PrimaryKeyDefinition primaryKeyDefinition = definition.getPrimaryKeyDefinition();
            if (primaryKeyDefinition == null) continue;
            System.out.println(primaryKeyDefinition.getName());
        }
    }

    public void printForeignKeys(DBConnection connection) throws Exception {
        for (TableDefinition definition : this.getTableDefinitions().values()) {
            for (ForeignKeyDefinition foreignKeyDefinition : definition.getForeignKeyDefinitions().values()) {
                System.out.println(foreignKeyDefinition.getFKName());
            }
        }
    }

    public void printIndexes(DBConnection connection) throws Exception {
        for (TableDefinition definition : this.getTableDefinitions().values()) {
            for (IndexDefinition indexDefinition : definition.getIndexDefinitions().values()) {
                System.out.println(indexDefinition.getIndexName());
            }
        }
    }

    protected final void updateTables() throws Exception {
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            PersistenceMetaData pmd = persistenceMetaData[i];
            if (!pmd.definesTable()) continue;
            String tableName = pmd.getTableName(this.pool);
            DBConnection connection = null;
            try {
                connection = this.pool.getConnection();
                TableDefinition tableDefinition = (TableDefinition)this.getTableDefinitions().get(tableName.toUpperCase());
                if (tableDefinition == null) {
                    if (!this.pool.getAutoCreateTables()) {
                        Log.info((String)("Table " + tableName + " not found!, Change configuration to 'auto create table' to 'true' in order to auto create the table!"));
                    } else {
                        this.createTable(pmd, connection);
                        this.createCommentOnTable(pmd, connection);
                        this.createCommentOnColumns(pmd, connection);
                    }
                } else {
                    this.updateColumns(pmd.getTableName(this.pool), pmd.getColumnDefinitions(this.pool), connection, tableDefinition);
                }
                this.updateAssociationTables(pmd, connection);
                Log.info((String)("Completed checking table " + tableName));
                continue;
            }
            catch (Exception e) {
                Log.warn((String)("Problem creating table " + tableName + " using " + pmd.getClass().getName()));
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
            finally {
                this.pool.returnConnection(connection);
            }
        }
        this.updateMetaData();
    }

    private void updateAssociationTables(PersistenceMetaData pmd, DBConnection connection) throws Exception {
        Map associativeTables = pmd.getAssociativeTableDefinitions(this.pool);
        if (associativeTables == null) {
            return;
        }
        for (AssociationMetaData amd : associativeTables.values()) {
            TableDefinition tableDefinition = (TableDefinition)this.getTableDefinitions().get(amd.getTableName().toUpperCase());
            if (tableDefinition == null) {
                if (!this.pool.getAutoCreateTables()) {
                    Log.info((String)("Association table " + amd.getTableName() + " not found!, Change configuration to 'auto create table' to 'true' in order to auto create the table!"));
                    continue;
                }
                Log.info((String)("Trying to create association table " + amd.getTableName() + " without Foreign Key and Index Constraints."));
                if (DBManager.executeUpdate(amd.getTableDefinition(), connection)) {
                    Log.info((String)("Associative support table " + amd.getTableName() + " created! [" + amd.getTableDefinition() + "]"));
                    continue;
                }
                throw new Exception("Could not create association table " + amd.getTableName() + ". See log for details.");
            }
            this.updateColumns(amd.getTableName(), amd.getColumnDefinitions(), connection, tableDefinition);
            Log.info((String)("Completed checking association table " + amd.getTableName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkSchema() {
        block6: {
            String schema = this.pool.getSchema();
            DBConnection connection = null;
            try {
                connection = this.pool.getConnection();
                if (schema == null || schema.trim().equals("")) break block6;
                Log.info((String)("Start checking schema " + schema));
                if (this.schemaExists(schema, connection)) break block6;
                try {
                    DBManager.executeUpdate("CREATE SCHEMA " + schema, connection);
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    Log.warn((String)("Could not create schema " + schema + ": " + e.getMessage() + " \n If schema does not yet exist you have to create manually!"));
                }
            }
            finally {
                this.pool.returnConnection(connection);
            }
        }
        return false;
    }

    private void createTable(PersistenceMetaData pmd, DBConnection connection) throws Exception {
        String tableName = pmd.getTableName(this.pool);
        String createInstruction = pmd.getTableDefinition(this.pool);
        Log.info((String)("Trying to create table " + tableName + " without Foreign Key and Index Constraints"));
        if (DBManager.executeUpdate(createInstruction, connection)) {
            Log.info((String)("Table " + tableName + " created! [" + createInstruction + "]"));
        } else {
            Log.error((String)("Could not create table " + tableName + "! See prevous messages!"));
        }
    }

    private void updatePrimaryKey(PersistenceMetaData pmd, DBConnection connection) throws Exception {
        if (!pmd.definesTable()) {
            return;
        }
        String tableName = pmd.getTableName(this.pool);
        Map constraints = pmd.getConstraintDefinitions(this.pool);
        this.updatePrimaryKey(tableName, constraints, connection);
        for (AssociationMetaData amd : pmd.getAssociativeTableDefinitions(this.pool).values()) {
            this.updatePrimaryKey(amd.getTableName(), amd.getConstraintDefinitions(), connection);
        }
    }

    private void updatePrimaryKey(String tableName, Map constraints, DBConnection connection) throws Exception, Error {
        for (String name : constraints.keySet()) {
            if (name == null || !name.startsWith("JSQL_PK_")) continue;
            String pkConstraint = (String)constraints.get(name);
            String fullTableName = this.prefix + tableName;
            PrimaryKeyDefinition primaryKeyDefinition = this.getPrimaryDefinition(tableName, name);
            if (primaryKeyDefinition != null) {
                if (this.isSamePrimaryKey(primaryKeyDefinition, pkConstraint)) continue;
                if (DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP PRIMARY KEY", connection)) {
                    Log.info((String)("Removed primary key constraint from table " + fullTableName + "."));
                } else {
                    throw new Error("Failed to remove primary key constraint from table " + fullTableName + ".");
                }
            }
            String fullConstraintName = this.prefix + name;
            String statement = "ALTER TABLE " + fullTableName + " ADD " + pkConstraint;
            if (DBManager.executeUpdate(statement, connection)) {
                Log.info((String)("Added primary key constraint " + fullConstraintName + " on table " + fullTableName + ". [" + pkConstraint + "]"));
                continue;
            }
            throw new Error("Failed to add constraint " + fullConstraintName + " on table " + fullTableName + ". [" + pkConstraint + "]");
        }
    }

    public PrimaryKeyDefinition getPrimaryDefinition(String tableName, String primaryKeyName) throws Exception {
        TableDefinition definition = this.getTableDefinition(tableName);
        if (definition == null) {
            return null;
        }
        return definition.getPrimaryKeyDefinition();
    }

    public boolean isSamePrimaryKey(PrimaryKeyDefinition pkDefinition, String pkConstraint) {
        int x = 0;
        int y = 0;
        if (pkConstraint == null || pkDefinition == null || (x = pkConstraint.indexOf("PRIMARY ")) < 0 || x + 6 >= pkConstraint.length() || (x = pkConstraint.indexOf(" KEY", x + 6)) < 0 || x + 4 >= pkConstraint.length() || (x = pkConstraint.indexOf("(", x + 4)) < 0 || x + 1 >= pkConstraint.length() || (y = pkConstraint.indexOf(")", x + 1)) < 0) {
            return false;
        }
        StringTokenizer c1 = new StringTokenizer(pkConstraint.substring(x + 1, y), ", ");
        PrimaryKeyColumn[] c2 = pkDefinition.getPrimaryKeyColumns();
        if (c1.countTokens() != c2.length) {
            return false;
        }
        int z = 0;
        while (c1.hasMoreTokens()) {
            if (c1.nextToken().equalsIgnoreCase(c2[z++].getColumnName())) continue;
            return false;
        }
        return true;
    }

    private void updateForeignKeys(PersistenceMetaData pmd, ConnectionProvider provider, DBConnection connection) throws Exception {
        if (!pmd.definesTable()) {
            return;
        }
        String tableName = pmd.getTableName(provider);
        Map constraints = pmd.getConstraintDefinitions(provider);
        this.updateForeignKeys(tableName, constraints, connection);
        for (AssociationMetaData amd : pmd.getAssociativeTableDefinitions(provider).values()) {
            this.updateForeignKeys(amd.getTableName(), amd.getConstraintDefinitions(), connection);
        }
    }

    private void updateForeignKeys(String tableName, Map constraints, DBConnection connection) throws Exception, Error {
        for (String name : constraints.keySet()) {
            String statement;
            if (name == null || !name.startsWith("JSQL_FK_")) continue;
            String fkConstraint = (String)constraints.get(name);
            String fullTableName = this.prefix + tableName;
            String fullConstraintName = this.prefix + name;
            ForeignKeyDefinition foreignKeyDefinition = this.getForeignKeyDefinition(tableName, name);
            if (foreignKeyDefinition != null) {
                if (this.isSameForeignKey(foreignKeyDefinition, fkConstraint)) continue;
                if (DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP FOREIGN KEY " + fullConstraintName, connection)) {
                    Log.info((String)("Removed foreign key constraint " + fullConstraintName + " from table " + fullTableName + "."));
                } else {
                    throw new Error("Failed to remove foreign key constraint " + fullConstraintName + " from table " + fullTableName + ".");
                }
            }
            if (DBManager.executeUpdate(statement = "ALTER TABLE " + fullTableName + " ADD " + fkConstraint, connection)) {
                Log.info((String)("Added foreign key constraint " + fullConstraintName + " on table " + fullTableName));
                continue;
            }
            throw new Error("Failed to add constraint " + fullConstraintName + " on table " + fullTableName + ". [" + fkConstraint + "]");
        }
    }

    public ForeignKeyDefinition getForeignKeyDefinition(String tableName, String foreignKeyName) throws Exception {
        TableDefinition definition = this.getTableDefinition(tableName);
        if (definition == null) {
            return null;
        }
        for (ForeignKeyDefinition foreignKeyDefinition : definition.getForeignKeyDefinitions().values()) {
            if (!foreignKeyDefinition.getFKName().equalsIgnoreCase(foreignKeyName)) continue;
            return foreignKeyDefinition;
        }
        return null;
    }

    public boolean isSameForeignKey(ForeignKeyDefinition fkDefinition, String fkConstraint) {
        int z2;
        int z1;
        int y2;
        int x2;
        int y1;
        int x1;
        block8: {
            block7: {
                int p = 0;
                x1 = 0;
                y1 = 0;
                x2 = 0;
                y2 = 0;
                z1 = 0;
                z2 = 0;
                int length = fkConstraint.length();
                if (fkConstraint == null || fkDefinition == null || (x1 = fkConstraint.indexOf("FOREIGN ")) < 0 || (p = x1 + 6) >= length || (x1 = fkConstraint.indexOf(" KEY", p)) < 0 || (p = x1 + 4) >= length || (x1 = fkConstraint.indexOf("(", p)) < 0 || (p = x1 + 1) >= length || (y1 = fkConstraint.indexOf(")", p)) < 0 || (p = y1 + 1) >= length || (z1 = fkConstraint.indexOf("REFERENCES ", p)) < 0) break block7;
                p = z1 += 11;
                if (z1 >= length) break block7;
                z2 = x2 = fkConstraint.indexOf("(", p);
                if (x2 >= 0 && (p = x2 + 1) < length && (y2 = fkConstraint.indexOf(")", p)) >= 0) break block8;
            }
            return false;
        }
        StringTokenizer t1 = new StringTokenizer(fkConstraint.substring(x1 + 1, y1), ", ");
        StringTokenizer t2 = new StringTokenizer(fkConstraint.substring(x2 + 1, y2), ", ");
        String fullTableName = fkConstraint.substring(z1, z2).trim();
        String tableName = fullTableName.indexOf(46) < 0 ? fullTableName : fullTableName.substring(fullTableName.indexOf(46) + 1).trim();
        ForeignKeyColumnPair[] fkcp = fkDefinition.getForeignKeyColumnPairs();
        if (t1.countTokens() != fkcp.length || t2.countTokens() != fkcp.length) {
            return false;
        }
        if (!tableName.equalsIgnoreCase(fkDefinition.getPKTableName())) {
            return false;
        }
        int z = 0;
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            if (!t1.nextToken().equalsIgnoreCase(fkcp[z].getFKColumnName())) {
                return false;
            }
            if (t2.nextToken().equalsIgnoreCase(fkcp[z++].getPKColumnName())) continue;
            return false;
        }
        return true;
    }

    private void updateIndexes(PersistenceMetaData pmd, ConnectionProvider provider, DBConnection connection) throws Exception {
        if (!pmd.definesTable()) {
            return;
        }
        Map indexes = pmd.getIndexDefinitions(provider);
        String tableName = pmd.getTableName(provider);
        this.updateIndexes(tableName, indexes, connection);
        for (AssociationMetaData amd : pmd.getAssociativeTableDefinitions(provider).values()) {
            this.updateIndexes(amd.getTableName(), amd.getIndexDefinitions(), connection);
        }
    }

    private void updateIndexes(String tableName, Map indexes, DBConnection connection) throws Exception, Error {
        String fullTableName = this.prefix + tableName;
        for (String name : indexes.keySet()) {
            String statement;
            String index = (String)indexes.get(name);
            IndexDefinition indexDefinition = this.getIndexDefinition(tableName, name);
            if (indexDefinition != null) {
                if (this.isSameIndex(indexDefinition, index)) continue;
                if (DBManager.executeUpdate("ALTER TABLE " + fullTableName + " DROP INDEX " + this.prefix + name, connection)) {
                    Log.info((String)("Removed index " + name + " from table " + fullTableName + "."));
                } else {
                    throw new Error("Failed to remove index " + name + " from table " + fullTableName + ".");
                }
            }
            if (DBManager.executeUpdate(statement = "CREATE " + index, connection)) {
                Log.info((String)("Added index " + name + " on table " + tableName));
                continue;
            }
            throw new Error("Failed to add index " + name + " on table " + tableName + ". [" + index + "]");
        }
    }

    public IndexDefinition getIndexDefinition(String tableName, String indexName) throws Exception {
        TableDefinition definition = this.getTableDefinition(tableName);
        if (definition == null) {
            return null;
        }
        for (IndexDefinition indexDefinition : definition.getIndexDefinitions().values()) {
            if (!indexDefinition.getIndexName().equalsIgnoreCase(indexName)) continue;
            return indexDefinition;
        }
        return null;
    }

    public boolean isSameIndex(IndexDefinition indexDefinition, String indexConstraint) {
        int x = 0;
        int y = 0;
        if (indexDefinition == null || indexConstraint == null || (x = indexConstraint.indexOf("(")) < 0 || x + 1 >= indexConstraint.length() || (y = indexConstraint.indexOf(")", x + 1)) < 0) {
            return false;
        }
        StringTokenizer c1 = new StringTokenizer(indexConstraint.substring(x + 1, y), ",");
        IndexColumn[] c2 = indexDefinition.getIndexColumns();
        if (c1.countTokens() != c2.length) {
            return false;
        }
        int z = 0;
        while (c1.hasMoreTokens()) {
            String def = c1.nextToken().trim();
            IndexColumn indexColumn = c2[z++];
            String sortSequence = "A";
            if (def.endsWith(" DESC")) {
                sortSequence = "D";
                def = def.substring(0, def.indexOf(" DESC")).trim();
            } else if (def.endsWith(" ASC")) {
                def = def.substring(0, def.indexOf(" ASC")).trim();
            }
            if (!def.equalsIgnoreCase(indexColumn.getColumnName())) {
                return false;
            }
            if (sortSequence.equalsIgnoreCase(indexColumn.getSortSequence())) continue;
            return false;
        }
        return true;
    }

    private void createCommentOnTable(PersistenceMetaData pmd, DBConnection connection) throws Exception {
        if (!pmd.definesTable() || !this.pool.getDBMapping().instructionCommentOnTableSupported()) {
            return;
        }
        String tableName = pmd.getTableName(this.pool);
        String tableDescription = pmd.getTableDescription();
        if (DBManager.executeUpdate("COMMENT ON TABLE " + this.prefix + tableName + " IS '" + tableDescription + "'", connection)) {
            Log.info((String)("Description added to table " + tableName));
        } else {
            Log.warn((String)("Failed to add description to table " + tableName));
        }
    }

    private void createCommentOnColumns(PersistenceMetaData pmd, DBConnection connection) throws Exception {
        if (!pmd.definesTable() || !this.pool.getDBMapping().instructionCommentOnColumnSupported()) {
            return;
        }
        String tableName = pmd.getTableName(this.pool);
        String[][] columns = pmd.getColumnDefinitions(this.pool);
        int zz = 0;
        for (int y = 0; y < columns.length && DBManager.executeUpdate("COMMENT ON COLUMN " + this.prefix + tableName + "." + columns[y][0] + " IS  '" + columns[y][4] + "'", connection); ++y) {
            ++zz;
        }
        Log.info((String)(zz + " column descriptions added to table " + tableName));
    }

    private void updateColumns(String tableName, String[][] columns, DBConnection connection, TableDefinition tableDefinition) throws Exception {
        Log.info((String)("Start checking " + String.valueOf(columns.length) + " columns of table " + tableName));
        HashMap cd = tableDefinition.getColumnDefinitions();
        for (int y = 0; y < columns.length; ++y) {
            String add_or_modify;
            ColumnDefinition columnDefinition = (ColumnDefinition)cd.get(columns[y][0].toUpperCase());
            if (columnDefinition != null && this.equals(columnDefinition, columns[y])) continue;
            if (columnDefinition == null) {
                if (!this.pool.getAutoAddColumns()) {
                    Log.info((String)("Column " + columns[y][0] + " from table " + tableName + " not found!, Change configuration to 'auto add columns' to let the system add the column!"));
                    continue;
                }
                add_or_modify = "ADD";
                Log.info((String)("Adding new column " + columns[y][0] + " to table " + tableName));
            } else {
                if (!this.pool.getAutoModifyColumns()) {
                    Log.warn((String)("Column " + columns[y][0] + " from table " + tableName + " does not equal definition! This might cause problems, Change configuration to 'auto modify columns' mode to let the system try to modify the column accordingly!"));
                    continue;
                }
                if (!this.readyToModifyColumns && this.isAS400Driver()) {
                    connection.executeUpdate(CHGJOB);
                    this.readyToDropColumns = true;
                }
                this.readyToModifyColumns = true;
                add_or_modify = "MODIFY";
                ColumnDefinition d = columnDefinition;
                String found = d.columnName + " " + d.typeName + "(" + d.columnSize + "," + d.decimalDigits + ")" + (d.columnDefinition == null ? "" : " DEFAULT " + d.columnDefinition) + (d.isNullable.equals("YES") ? "" : " NOT NULL");
                String required = columns[y][0] + " " + columns[y][1] + " " + (columns[y][2] == null ? "" : " DEFAULT " + columns[y][2]) + " " + columns[y][3];
                Log.info((String)("Modifying column " + columns[y][0] + " from table " + tableName + "[ required = \"" + required + "\", found = \"" + found + "\"]"));
            }
            boolean done = false;
            boolean initialized = false;
            if (add_or_modify.equals("MODIFY") && !DBManager.isNullable(columns[y]) && columns[y][2] != null) {
                Log.info((String)("Initialise column " + columns[y][0] + ": " + columns[y][2]));
                if (DBManager.executeUpdate("UPDATE " + this.pool.getPrefix() + tableName + " SET " + columns[y][0] + " = " + columns[y][2] + " WHERE " + columns[y][0] + " IS  NULL ", connection)) {
                    Log.info((String)"Column initialized");
                } else {
                    Log.warn((String)("Failed to initialise column " + tableName + "." + columns[y][0] + ": " + columns[y][2] + "! See previous messages."));
                }
            }
            if (columns[y][3] != null && columns[y][2] != null) {
                done = initialized = DBManager.executeUpdate("ALTER TABLE " + this.pool.getPrefix() + tableName + " " + add_or_modify + " COLUMN " + columns[y][0] + " " + columns[y][1] + " DEFAULT " + columns[y][2] + " " + columns[y][3], connection);
            }
            if (!done && columns[y][2] != null) {
                done = initialized = DBManager.executeUpdate("ALTER TABLE " + this.pool.getPrefix() + tableName + " " + add_or_modify + " COLUMN " + columns[y][0] + " " + columns[y][1] + " DEFAULT " + columns[y][2], connection);
            }
            if (!done && columns[y][3] != null) {
                done = DBManager.executeUpdate("ALTER TABLE " + this.pool.getPrefix() + tableName + " " + add_or_modify + " COLUMN " + columns[y][0] + " " + columns[y][1] + " " + columns[y][3], connection);
            }
            if (!done) {
                done = DBManager.executeUpdate("ALTER TABLE " + this.pool.getPrefix() + tableName + " " + add_or_modify + " COLUMN " + columns[y][0] + " " + columns[y][1], connection);
            }
            if (done) {
                if (columnDefinition == null) {
                    Log.info((String)("Added column " + columns[y][0] + " to table " + tableName + "!"));
                } else {
                    Log.info((String)("Modified column " + columns[y][0] + " from table " + tableName + "!"));
                }
                if (!initialized && add_or_modify.equals("ADD") && columns[y][2] != null) {
                    Log.info((String)("Initialise new column " + columns[y][0] + ": " + columns[y][2]));
                    if (DBManager.executeUpdate("UPDATE " + this.pool.getPrefix() + tableName + " SET " + columns[y][0] + " = " + columns[y][2], connection)) {
                        Log.info((String)"Column initialized");
                    } else {
                        Log.warn((String)("Failed to initialise new column " + tableName + "." + columns[y][0] + ": " + columns[y][2] + "! See previous messages."));
                    }
                }
                if (!this.pool.getDBMapping().instructionCommentOnColumnSupported()) continue;
                Log.info((String)("Add description " + columns[y][4] + " to new column " + columns[y][0]));
                if (DBManager.executeUpdate("COMMENT ON COLUMN " + this.pool.getPrefix() + tableName + "." + columns[y][0] + " IS  '" + columns[y][4] + "'", connection)) {
                    Log.info((String)"Column description added");
                    continue;
                }
                Log.warn((String)("Failed to add column description!" + columns[y][4] + " to new column " + tableName + "." + columns[y][0] + "! See previous messages."));
                continue;
            }
            if (add_or_modify.equals("ADD")) {
                Log.error((String)("Could not add column " + columns[y][0] + " to table " + tableName + "! See previous messages."));
                continue;
            }
            Log.error((String)("Could not modify column " + columns[y][0] + " from table " + tableName + "! See previous messages."));
        }
    }

    private boolean isAS400Driver() {
        return this.pool.getDriver().startsWith("com.ibm.as400.access.AS400JDBCDriver") || this.pool.getDriver().startsWith("com.ibm.db2.jdbc.app.DB2Driver");
    }

    protected final void removeRedundantColumns() throws Exception {
        DBConnection con = null;
        try {
            con = this.pool.getConnection();
            this.removeRedundantColumns(con);
        }
        finally {
            this.pool.returnConnection(con);
        }
    }

    public void removeRedundantColumns(DBConnection connection) throws Exception {
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            PersistenceMetaData pmd = persistenceMetaData[i];
            if (!pmd.definesTable()) continue;
            String tableName = pmd.getTableName(this.pool);
            try {
                TableDefinition tableDefinition = (TableDefinition)this.getTableDefinitions().get(tableName.toUpperCase());
                if (tableDefinition != null) {
                    this.removeRedundantColumns(pmd.getTableName(this.pool), pmd.getColumnDefinitions(this.pool), connection, tableDefinition);
                }
                for (AssociationMetaData amd : pmd.getAssociativeTableDefinitions(this.pool).values()) {
                    tableName = amd.getTableName();
                    tableDefinition = (TableDefinition)this.getTableDefinitions().get(tableName.toUpperCase());
                    if (tableDefinition == null) continue;
                    this.removeRedundantColumns(amd.getTableName(), amd.getColumnDefinitions(), connection, tableDefinition);
                }
                continue;
            }
            catch (Exception e) {
                Log.warn((String)("Problem encountered removing redundant columns on table table " + tableName + " using " + pmd.getClass().getName()));
                Log.error((String)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }

    private void removeRedundantColumns(String tableName, String[][] columns, DBConnection connection, TableDefinition tableDefinition) throws Exception {
        Log.info((String)("Start removing redundant columns of table " + tableName));
        HashMap cd = tableDefinition.getColumnDefinitions();
        for (String columnName : cd.keySet()) {
            if (DBManager.containsColumnDefinition(columns, columnName)) continue;
            if (!this.pool.getAutoDropColumns()) {
                Log.info((String)("Column " + columnName + " from table " + tableName + " no langer part of the model! Change configuration to 'auto drop columns' to let the system try to drop the column!"));
                continue;
            }
            if (!this.readyToModifyColumns && this.isAS400Driver()) {
                connection.executeUpdate(CHGJOB);
                this.readyToModifyColumns = true;
            }
            this.readyToDropColumns = true;
            Log.info((String)("Dropping column " + columnName + " from table " + tableName));
            if (DBManager.executeUpdate("ALTER TABLE " + this.prefix + tableName + " DROP COLUMN " + columnName, connection)) {
                Log.info((String)("Column " + columnName + " from table " + tableName + " dropped!"));
                continue;
            }
            Log.info((String)("Could not drop column " + columnName + " from table " + tableName + "!"));
        }
    }

    public TableDefinition getTableDefinition(String tableName) throws Exception {
        Iterator iterator = this.tableDefinitions == null ? TableDefinition.getTableDefinitions(tableName, new String[]{"TABLE"}, this.pool).values().iterator() : this.getTableDefinitions().values().iterator();
        while (iterator.hasNext()) {
            TableDefinition definition = (TableDefinition)iterator.next();
            if (!this.equalsIgnoreCase(tableName, definition.getTableName())) continue;
            return definition;
        }
        return null;
    }

    public boolean equalsIgnoreCase(String a, String b) {
        a = a == null || a.trim().length() == 0 ? null : a.trim();
        String string = b = b == null || b.trim().length() == 0 ? null : b.trim();
        if (a == null) {
            return b == null;
        }
        return a.equalsIgnoreCase(b);
    }

    private static boolean executeUpdate(String query, DBConnection con) {
        try {
            con.executeUpdate(query);
            return true;
        }
        catch (SQLException e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean schemaExists() {
        String schema = this.pool.getSchema();
        if (schema == null || schema.trim().length() == 0) {
            return true;
        }
        DBConnection connection = this.pool.getConnection();
        boolean exists = this.schemaExists(schema, connection);
        this.pool.returnConnection(connection);
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean schemaExists(String schema, DBConnection con) {
        boolean exists;
        String version = null;
        ResultSet rs = null;
        try {
            rs = con.executeQuery("SELECT VERSION_NUMBER FROM " + this.prefix + VERSION_DATA_TABLE + " WHERE " + TYPE_COLUMN + " = '" + APPLICATION_VERSION + "'", true);
            if (rs.next()) {
                version = rs.getString(1);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        boolean bl = exists = version != null;
        if (Log.debug()) {
            Log.debug((String)("Schema " + schema + (exists ? " exists " : " does not exists ")));
        }
        return exists;
    }

    private static boolean containsColumnDefinition(String[][] columns, String columnName) {
        for (int x = 0; x < columns.length; ++x) {
            if (!columns[x][0].equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(ColumnDefinition cd1, String[] cd2) throws Exception {
        if (DBManager.isNullable(cd1) != DBManager.isNullable(cd2)) {
            Log.info((String)("Column " + cd2[0] + " in database is " + (DBManager.isNullable(cd1) ? "" : "not ") + "nullable but should " + (DBManager.isNullable(cd1) ? "" : "not ") + "be nullable according to definition!"));
            return false;
        }
        if (!DBManager.translateToDefaultTypeName(DBManager.sqlType(cd1)).equalsIgnoreCase(DBManager.translateToDefaultTypeName(DBManager.sqlType(cd2)))) {
            String type1 = DBManager.translateToDefaultTypeName(DBManager.sqlType(cd1));
            String type2 = DBManager.translateToDefaultTypeName(DBManager.sqlType(cd2));
            Log.info((String)("Column " + cd2[0] + " in database is of type " + type1 + " but should be type " + type2 + " according to definition!"));
            if (type1 == null || type2 == null || !type1.equalsIgnoreCase("char") && !type1.equalsIgnoreCase("varchar") || type1.equalsIgnoreCase("char") && !type2.equalsIgnoreCase("varchar") || type1.equalsIgnoreCase("varchar") && !type2.equalsIgnoreCase("char")) {
                return false;
            }
        }
        if (DBManager.hasLength(cd2) && DBManager.length(cd1) != DBManager.length(cd2)) {
            Log.info((String)("Column " + cd2[0] + " in database has length " + DBManager.length(cd1) + " but should have length " + DBManager.length(cd2) + " according to definition!"));
            return false;
        }
        if (DBManager.hasDecimals(cd2) && DBManager.decimals(cd1) != DBManager.decimals(cd2)) {
            Log.info((String)("Column " + cd2[0] + " in database has " + DBManager.decimals(cd1) + " decimals but should have " + DBManager.decimals(cd2) + " decimals according to definition!"));
            return false;
        }
        if (!DBManager.removeEnclosingBrackets(DBManager.defaultValue(cd1)).equals(DBManager.removeEnclosingBrackets(DBManager.defaultValue(cd2)))) {
            if (this.columnDefintionInAccordanceStoredMetaData(cd1.tableName, cd2)) {
                return true;
            }
            Log.info((String)("Column " + cd2[0] + " in database has defaultvalue " + DBManager.defaultValue(cd1) + " but should defaultvalue " + DBManager.defaultValue(cd2) + " according to definition!"));
            return false;
        }
        return true;
    }

    private static boolean isNullable(ColumnDefinition cd) {
        return cd.isNullable.trim().equals("YES");
    }

    private static boolean isNullable(String[] cd) {
        return cd[3].trim().indexOf("NOT NULL") == -1;
    }

    private static String sqlType(ColumnDefinition cd) {
        return cd.typeName.trim();
    }

    private static String sqlType(String[] cd) {
        int i = cd[1].indexOf(40);
        if (i < 0) {
            return cd[1].trim();
        }
        return cd[1].substring(0, i).trim();
    }

    private static int length(ColumnDefinition cd) {
        return cd.columnSize;
    }

    private static boolean hasLength(String[] cd) {
        return cd[1].indexOf(40) > -1;
    }

    private static int length(String[] cd) {
        if (cd[1].indexOf(40) <= -1) {
            return -1;
        }
        if (cd[1].indexOf(44) > -1) {
            return Integer.parseInt(cd[1].substring(cd[1].indexOf(40) + 1, cd[1].indexOf(44)).trim());
        }
        return Integer.parseInt(cd[1].substring(cd[1].indexOf(40) + 1, cd[1].indexOf(41)).trim());
    }

    private static boolean hasDecimals(String[] cd) {
        return cd[1].indexOf(44) > -1;
    }

    private static int decimals(ColumnDefinition cd) {
        return cd.decimalDigits;
    }

    private static int decimals(String[] cd) {
        return Integer.parseInt(cd[1].substring(cd[1].indexOf(44) + 1, cd[1].indexOf(41)).trim());
    }

    private static String defaultValue(ColumnDefinition cd) {
        if (cd.columnDefinition == null) {
            return "";
        }
        return cd.columnDefinition;
    }

    private static String defaultValue(String[] cd) {
        return cd[2] == null ? "" : cd[2].trim();
    }

    private static String removeEnclosingBrackets(String string) {
        if (string == null) {
            return "";
        }
        if ((string = string.trim()).startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private static String translateToDefaultTypeName(String type) {
        if ((type = type.trim()).equalsIgnoreCase("int")) {
            return "INTEGER";
        }
        return type;
    }

    protected final void persistMetaData() throws Exception {
        DBConnection connection = null;
        try {
            connection = this.pool.getConnection();
            this.storeMetaData(connection);
            this.setDBJSQLVersion(connection);
            this.setDBApplicationVersion(this.getNewDataBaseVersion(), connection);
        }
        finally {
            this.pool.returnConnection(connection);
        }
    }

    private void storeMetaData(DBConnection connection) throws Exception {
        TableDefinition td = this.getTableDefinition(META_DATA_TABLE);
        if (td != null && td.getColumnDefinitions().size() < 9) {
            connection.executeUpdate("DROP TABLE " + this.prefix + META_DATA_TABLE);
            td = null;
        }
        if (td == null) {
            connection.executeUpdate("CREATE TABLE " + this.getPrefix() + META_DATA_TABLE + " (" + BO_PACKAGE_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 250, 0) + " NOT NULL\t," + BO_NAME_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 125, 0) + " NOT NULL\t," + BO_ATTRIBUTE_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 125, 0) + " NOT NULL\t," + TABLE_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 128, 0) + " NOT NULL ," + COLUMN_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 30, 0) + " NOT NULL ," + SQL_DEFINITION_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 100, 0) + " NOT NULL ," + DEFAULT_VALUE_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 250, 0) + " ," + EXTENTION_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 100, 0) + " ," + DESCRIPTION_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 250, 0) + " , PRIMARY KEY(" + BO_PACKAGE_COLUMN + ", " + BO_NAME_COLUMN + ", " + BO_ATTRIBUTE_COLUMN + "))");
            this.updateMetaData();
        } else {
            connection.executeUpdate("DELETE FROM " + this.prefix + META_DATA_TABLE + " WHERE 0=0 ");
        }
        PersistenceMetaData[] persistenceMetaData = this.getPersistenceMetaDataArray();
        for (int i = 0; i < persistenceMetaData.length; ++i) {
            String[] columnDefinition;
            PersistenceMetaData pmd = persistenceMetaData[i];
            String tableName = pmd.getTableName(this.pool);
            String boName2 = pmd.getBusinessObjectName();
            int xyz = pmd.getClass().getName().lastIndexOf(".impl.");
            String _package = xyz < 0 ? "" : pmd.getClass().getName().substring(0, xyz);
            String[][] columnDefinitions = pmd.getPersistingPMD().getColumnDefinitions(this.pool);
            for (String javaVariableName : pmd.getJavaVariableNames()) {
                String columnName = pmd.getFieldNameForJavaField(javaVariableName, this.pool);
                if (columnName == null) continue;
                columnDefinition = DBManager.getColumnDefinition(columnName, columnDefinitions);
                this.insertDBMetaDataRecord(connection, _package, boName2, javaVariableName, tableName, columnDefinition);
            }
            Map amds = pmd.getAssociativeTableDefinitions(this.pool);
            for (String boName2 : amds.keySet()) {
                AssociationMetaData amd = (AssociationMetaData)amds.get(boName2);
                tableName = amd.getTableName();
                columnDefinition = amd.getColumnDefinitions();
                for (int j = 0; j < columnDefinition.length; ++j) {
                    this.insertDBMetaDataRecord(connection, "[" + _package + "]", boName2, columnDefinition[j][0].toLowerCase(), tableName, (String[])columnDefinition[j]);
                }
            }
        }
    }

    private void insertDBMetaDataRecord(DBConnection connection, String _package, String boName, String attributeName, String tableName, String[] columnDefinition) throws SQLException {
        String columnName = null;
        String sqlDefinition = null;
        String defaultValue = null;
        String instuctionExtention = null;
        String columnDescription = "";
        if (columnDefinition != null) {
            columnName = columnDefinition[0];
            sqlDefinition = columnDefinition[1];
            defaultValue = columnDefinition[2];
            instuctionExtention = columnDefinition[3];
            columnDescription = columnDefinition[4];
        }
        connection.executeUpdate("INSERT INTO " + this.prefix + META_DATA_TABLE + " VALUES ('" + this.escape(_package) + "','" + this.escape(boName) + "','" + this.escape(attributeName) + "','" + this.escape(tableName) + "','" + this.escape(columnName) + "','" + this.escape(sqlDefinition) + "'," + (defaultValue == null ? "NULL" : "'" + this.escape(defaultValue) + "'") + "," + (instuctionExtention == null ? "NULL" : "'" + this.escape(instuctionExtention) + "'") + ",'" + this.escape(columnDescription) + "')");
    }

    private String escape(String value) {
        if (value == null || value.indexOf("'") < 0) {
            return value;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\'') {
                b.append(c);
            }
            b.append(c);
        }
        return b.toString();
    }

    private static String[] getColumnDefinition(String columnName, String[][] columnDefintions) {
        for (int i = 0; i < columnDefintions.length; ++i) {
            if (!columnDefintions[i][0].equalsIgnoreCase(columnName)) continue;
            return columnDefintions[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean columnDefintionInAccordanceStoredMetaData(String tableName, String[] columns) throws Exception {
        if (!this.schemaExists() || columns == null || columns.length < 4) {
            return false;
        }
        TableDefinition td = this.getTableDefinition(META_DATA_TABLE);
        if (td == null) {
            return false;
        }
        DBConnection con = this.pool.getConnection();
        String selectClause = "SQL_DEFINITION , DEFAULT_VALUE , EXTENTION, DESCRIPTION";
        String table = this.prefix + META_DATA_TABLE;
        String whereClause = "TABLE_NAME = '" + tableName + "' AND " + COLUMN_COLUMN + "= '" + columns[0] + "'";
        ResultSet rs = null;
        try {
            rs = con.executeQuery("SELECT " + selectClause + " FROM " + table + " WHERE " + whereClause);
            if (rs.next()) {
                if (!this.equalsIgnoreCase(rs.getString(1), columns[1])) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.equalsIgnoreCase(rs.getString(2), columns[2])) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.equalsIgnoreCase(rs.getString(3), columns[3])) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.equalsIgnoreCase(rs.getString(4), columns[4])) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (con != null) {
                this.pool.returnConnection(con);
            }
        }
        return false;
    }

    public String getDBApplicationVersion() throws Exception {
        return this.getDBVersion(APPLICATION_VERSION);
    }

    public String getDBJSQLVersion() throws Exception {
        return this.getDBVersion(JSQL_VERSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDBVersion(String type) throws Exception {
        String version = null;
        if (!this.schemaExists()) {
            return version;
        }
        TableDefinition td = this.getTableDefinition(VERSION_DATA_TABLE);
        if (td == null) {
            return version;
        }
        DBConnection con = this.pool.getConnection();
        ResultSet rs = null;
        try {
            rs = con.executeQuery("SELECT VERSION_NUMBER FROM " + this.prefix + VERSION_DATA_TABLE + " WHERE " + TYPE_COLUMN + " = '" + type + "'");
            if (rs.next()) {
                version = rs.getString(1);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        this.pool.returnConnection(con);
        return version;
    }

    private void setDBApplicationVersion(String version, DBConnection connection) throws Exception {
        this.setDBVersion(APPLICATION_VERSION, version, connection);
    }

    private void setDBJSQLVersion(DBConnection connection) throws Exception {
        this.setDBVersion(JSQL_VERSION, CURRENT_JSQL_VERSION, connection);
    }

    private void setDBVersion(String type, String version, DBConnection con) throws Exception {
        TableDefinition td = this.getTableDefinition(VERSION_DATA_TABLE);
        if (td == null) {
            con.executeUpdate("CREATE TABLE " + this.getPrefix() + VERSION_DATA_TABLE + " (" + TYPE_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 25, 0) + " NOT NULL\t," + VERSION_COLUMN + " " + this.pool.getDBMapping().getSQLDefinition("String", 25, 0) + " NOT NULL )");
            this.updateMetaData();
        }
        con.executeUpdate("DELETE FROM " + this.prefix + VERSION_DATA_TABLE + " WHERE " + TYPE_COLUMN + "='" + type + "'");
        con.executeUpdate("INSERT INTO " + this.prefix + VERSION_DATA_TABLE + " VALUES ('" + type + "','" + version + "')");
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected String getCurrentDataBaseVersion() {
        return this.db_application_version == null ? null : this.db_application_version.trim();
    }

    protected final String getCurrentJSQLVersion() {
        return this.db_jsql_version == null ? null : this.db_jsql_version.trim();
    }

    public String getTableName(Class bo) throws Exception {
        String classPackage = bo.getPackage() == null ? "" : bo.getPackage().getName();
        String className = bo.getName().substring(classPackage.length() == 0 ? 0 : classPackage.length() + 1);
        return this.getTableName(classPackage, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTableName(String classPackage, String className) throws Exception {
        PersistenceMetaData pmd = this.getPersistentMetaDataByBOName(classPackage = classPackage == null ? "" : classPackage, className);
        if (pmd != null) {
            return this.getPrefix() + pmd.getTableName(this.pool);
        }
        TableDefinition td = this.getTableDefinition(META_DATA_TABLE);
        if (td != null && td.getColumnDefinitions().size() >= 9) {
            String selectClause = TABLE_COLUMN;
            String table = this.getPrefix() + META_DATA_TABLE;
            String whereClause = "BO_PACKAGE = '" + classPackage + "' AND " + BO_NAME_COLUMN + "= '" + className + "'";
            DBConnection con = this.pool.getConnection();
            ResultSet rs = null;
            try {
                rs = con.executeQuery("SELECT DISTINCT " + selectClause + " FROM " + table + " WHERE " + whereClause);
                if (rs.next()) {
                    String string = this.getPrefix() + rs.getString(1);
                    return string;
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                this.pool.returnConnection(con);
            }
        }
        throw new Exception("No mapping to database table found for " + className + " in " + classPackage + "!");
    }

    public String getColumnName(Class bo, String classAttribute) throws Exception {
        String classPackage = bo.getPackage() == null ? "" : bo.getPackage().getName();
        String className = bo.getName().substring(classPackage.length() == 0 ? 0 : classPackage.length() + 1);
        return this.getColumnName(classPackage, className, classAttribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName(String classPackage, String className, String classAttribute) throws Exception {
        PersistenceMetaData pmd = this.getPersistentMetaDataByBOName(classPackage = classPackage == null ? "" : classPackage, className);
        if (pmd != null && pmd.containsJavaVariable(classAttribute)) {
            return pmd.getFieldNameForJavaField(classAttribute, this.pool);
        }
        TableDefinition td = this.getTableDefinition(META_DATA_TABLE);
        if (td != null && td.getColumnDefinitions().size() >= 9) {
            String selectClause = COLUMN_COLUMN;
            String table = this.getPrefix() + META_DATA_TABLE;
            String whereClause = "BO_PACKAGE = '" + classPackage + "' AND " + BO_NAME_COLUMN + "= '" + className + "' AND " + BO_ATTRIBUTE_COLUMN + "= '" + classAttribute + "'";
            DBConnection con = this.pool.getConnection();
            ResultSet rs = null;
            try {
                rs = con.executeQuery("SELECT DISTINCT " + selectClause + " FROM " + table + " WHERE " + whereClause);
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                this.pool.returnConnection(con);
            }
        }
        throw new Exception("No database mapping found for attribute " + className + "." + classAttribute + " in " + classPackage + "." + classAttribute + "!");
    }

    private PersistenceMetaData getPersistentMetaDataByBOName(String _package, String name) throws Exception {
        PersistenceMetaData[] pmds = this.getPersistenceMetaDataArray();
        for (int i = 0; i < pmds.length; ++i) {
            if (!pmds[i].getBusinessObjectName().equals(name) || _package != null && !pmds[i].getClass().getName().startsWith(_package)) continue;
            return pmds[i];
        }
        return null;
    }

    protected void logMetaData() throws SQLException {
        try {
            Log.info((String)("Database : " + this.meta.getDatabaseProductName() + ", version : " + this.meta.getDatabaseProductVersion()));
            Log.info((String)("Driver : " + this.meta.getDriverName() + ", version: " + this.meta.getDriverVersion() + " [major version=" + this.meta.getDriverMajorVersion() + ",minor version=" + this.meta.getDriverMinorVersion() + "]"));
            if (this.meta.supportsANSI92FullSQL()) {
                Log.info((String)"Database provides full ANSI SQL 92 support.");
            } else if (this.meta.supportsANSI92IntermediateSQL()) {
                Log.info((String)"Database provides intermediate ANSI SQL 92 support.");
            } else if (this.meta.supportsANSI92EntryLevelSQL()) {
                Log.info((String)"Database provides entry level ANSI SQL 92 support.");
            } else {
                Log.info((String)"Database not fully provides entry level ANSI SQL 92 support.");
            }
            Log.info((String)("Database " + (this.meta.supportsCoreSQLGrammar() ? "supports" : "does not support") + " the core SQL grammar."));
            Log.info((String)("Database " + (this.meta.supportsExtendedSQLGrammar() ? "supports" : "does not support") + " the extended SQL grammar."));
            Log.info((String)("Database uses in addition to SQL 92 the following SQL keywords: " + this.meta.getSQLKeywords()));
            Log.info((String)("Database " + (this.meta.supportsAlterTableWithAddColumn() ? "supports" : "does not support") + " the AlterTable With Add Column instruction."));
            Log.info((String)("Database " + (this.meta.supportsAlterTableWithDropColumn() ? "supports" : "does not support") + " the AlterTable With Drop Column instruction."));
            Log.info((String)("Database " + (this.meta.supportsFullOuterJoins() ? "fully supports" : "does not fully supports") + " Outher Joins."));
            if (!this.meta.supportsFullOuterJoins()) {
                Log.info((String)("Database " + (this.meta.supportsLimitedOuterJoins() ? "has limmited support for " : "does not support") + " Outher Joins."));
            }
            Log.info((String)("Database " + (this.meta.supportsTransactions() ? "supports" : "does not support") + " Transactions."));
            if (this.meta.supportsTransactions()) {
                if (this.meta.getDefaultTransactionIsolation() == 0) {
                    Log.info((String)"Default transaction isolationlevel = \"NONE\"");
                }
                if (this.meta.getDefaultTransactionIsolation() == 2) {
                    Log.info((String)"Default transaction isolationlevel = \"READ COMMITED\"");
                }
                if (this.meta.getDefaultTransactionIsolation() == 1) {
                    Log.info((String)"Default transaction isolationlevel = \"READ UNCOMMITED\"");
                }
                if (this.meta.getDefaultTransactionIsolation() == 4) {
                    Log.info((String)"Default transaction isolationlevel = \"REPEATABLE READ\"");
                }
                if (this.meta.getDefaultTransactionIsolation() == 8) {
                    Log.info((String)"DB uses as default transaction isolationlevel: \"SERIALIZABLE\"");
                }
                Log.info((String)("Database " + (this.meta.supportsTransactionIsolationLevel(2) ? "supports" : "does not support") + " transaction isolation level \"READ COMMITTED\"."));
                Log.info((String)("Database " + (this.meta.supportsTransactionIsolationLevel(1) ? "supports" : "does not support") + " transaction isolation level \"READ UNCOMMITTED\"."));
                Log.info((String)("Database " + (this.meta.supportsTransactionIsolationLevel(4) ? "supports" : "does not support") + " transaction isolation level \"REPEATABLE READ\"."));
                Log.info((String)("Database " + (this.meta.supportsTransactionIsolationLevel(8) ? "supports" : "does not support") + " transaction isolation level \"SERIALIZABLE\"."));
            }
            Log.info((String)("Database " + (this.meta.supportsUnion() ? "supports" : "does not support") + " Union."));
            Log.info((String)("Database " + (this.meta.supportsUnionAll() ? "supports" : "does not support") + " Union All."));
            Log.info((String)("Database " + (this.meta.supportsBatchUpdates() ? "supports" : "does not support") + " Batch Updates."));
            if (this.meta.getMaxSchemaNameLength() > 0) {
                Log.info((String)("Max length schema names: " + this.meta.getMaxSchemaNameLength()));
            }
            if (this.meta.getMaxTableNameLength() > 0) {
                Log.info((String)("Max length table names: " + this.meta.getMaxTableNameLength()));
            }
            if (this.meta.getMaxColumnNameLength() > 0) {
                Log.info((String)("Max length column names: " + this.meta.getMaxColumnNameLength()));
            }
            if (this.meta.getMaxStatementLength() > 0) {
                Log.info((String)("Max length statements: " + this.meta.getMaxStatementLength()));
            }
            if (this.meta.getMaxStatements() > 0) {
                Log.info((String)("Max number of statements: " + this.meta.getMaxStatements()));
            }
            if (this.meta.getMaxConnections() > 0) {
                Log.info((String)("Max number of connections: " + this.meta.getMaxConnections()));
            }
            if (this.meta.getMaxColumnsInTable() > 0) {
                Log.info((String)("Max number of columns in table: " + this.meta.getMaxColumnsInTable()));
            }
            if (this.meta.getMaxColumnsInIndex() > 0) {
                Log.info((String)("Max number of columns in index: " + this.meta.getMaxColumnsInIndex()));
            }
            if (this.meta.getMaxColumnsInSelect() > 0) {
                Log.info((String)("Max number of columns in select: " + this.meta.getMaxColumnsInSelect()));
            }
            if (this.meta.getMaxColumnsInOrderBy() > 0) {
                Log.info((String)("Max number of columns in order by: " + this.meta.getMaxColumnsInOrderBy()));
            }
            if (this.meta.getMaxColumnsInGroupBy() > 0) {
                Log.info((String)("Max number of columns in group by: " + this.meta.getMaxColumnsInGroupBy()));
            }
            if (this.meta.usesLocalFiles()) {
                Log.info((String)"Database stores tables in a local file");
            }
            if (this.meta.usesLocalFilePerTable()) {
                Log.info((String)"Database uses a file for each table");
            }
            if (this.meta.storesLowerCaseIdentifiers()) {
                Log.info((String)"Database treats mixed case unquoted SQL identifiers as case insensitive and stores them in lower case.");
            }
            if (this.meta.storesLowerCaseQuotedIdentifiers()) {
                Log.info((String)"Database treats mixed case quoted SQL identifiers as case insensitive and stores them in lower case.");
            }
            if (this.meta.storesMixedCaseIdentifiers()) {
                Log.info((String)"Database treats mixed case unquoted SQL identifiers as case insensitive and stores them in mixed case.");
            }
            if (this.meta.storesMixedCaseQuotedIdentifiers()) {
                Log.info((String)"Database treats mixed case quoted SQL identifiers as case sensitive and as a result stores them in mixed case.");
            }
            if (this.meta.storesUpperCaseIdentifiers()) {
                Log.info((String)"Database treats mixed case unquoted SQL identifiers as case insensitive and stores them in upper case.");
            }
            if (this.meta.storesUpperCaseQuotedIdentifiers()) {
                Log.info((String)"Database treats mixed case quoted SQL identifiers as case insensitive and stores them in upper case.");
            }
            if (!this.meta.getIdentifierQuoteString().equals(" ")) {
                Log.info((String)("String used to quote SQL identifiers : " + this.meta.getIdentifierQuoteString()));
            }
            Log.info((String)("This database " + (this.meta.supportsLikeEscapeClause() ? "does" : "does not") + " support specifying a LIKE escape clause"));
            Log.info((String)("String to escape wildcard characters with this database : " + this.meta.getSearchStringEscape()));
            Log.info((String)("String functions available with this database: " + this.meta.getStringFunctions()));
            Log.info((String)("Numeric functions available with this database: " + this.meta.getNumericFunctions()));
            Log.info((String)("System functions available with this database: " + this.meta.getSystemFunctions()));
            Log.info((String)("Time Date functions available with this database: " + this.meta.getTimeDateFunctions()));
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public DBConnectionPool getPool() {
        return this.pool;
    }

    public boolean isPostConverted() {
        return this.postConverted;
    }

    public boolean isPreConverted() {
        return this.preConverted;
    }
}

