/*
 * Decompiled with CFR 0.152.
 */
package nl.ibs.jsql.sql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import nl.ibs.jsql.sql.ConnectionProvider;
import nl.ibs.jsql.sql.PersistenceMetaData;

public class QueryTranslator {
    private static HashMap operands = new HashMap();
    private static HashMap functions = new HashMap();
    private static Set methodNames = new HashSet();
    private static Set compareOperands = new HashSet();
    private static Set andOperands = new HashSet();
    private static Set orOperands = new HashSet();
    private static String delimeters = "\n\r\t,()[]+-*/<>=:|$&!. ";
    private static final String variablePrefix = "?";
    private static String[] andSymbols = new String[]{"AND", "and", "&&", "&"};

    public static String translateFreeQuery(String selectClause, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        return QueryTranslator.translateQuery(selectClause, pmd, provider, imports);
    }

    public static String translateObjectSelectClause(String selectClause, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        String ts = QueryTranslator.translateQuery(selectClause, pmd, provider, imports);
        return provider.getPrefix() + pmd.getTableName(provider) + ".* " + (ts == null || ts.trim().equals("") ? "" : " , " + ts);
    }

    public static String translateObjectFromClause(Set tables, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        String baseTable = pmd.getTableName(provider);
        String prefix = provider.getPrefix();
        String from = provider.getPrefix() + baseTable;
        if (!tables.isEmpty()) {
            for (String table : tables) {
                if (baseTable.equals(table)) continue;
                from = from + ", ";
                from = from + provider.getPrefix();
                from = from + table;
            }
        }
        if (!tables.contains(baseTable)) {
            tables.add(baseTable);
        }
        return from;
    }

    public static String translateObjectFilterClause(String filterClause, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        return QueryTranslator.translateQuery(filterClause, pmd, provider, imports);
    }

    public static String translateObjectSetClause(String setClause, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        return QueryTranslator.translateQuery(setClause, pmd, provider, imports);
    }

    public static void processObjectOrderClause(String orderByClause, PersistenceMetaData pmd, ConnectionProvider provider, Map imports, Set tables, StringBuffer orderBuffer, StringBuffer fromBuffer, StringBuffer selectBuffer) throws Exception {
        QueryTranslator.processOrder(orderByClause, pmd, provider, imports, tables, orderBuffer, fromBuffer, selectBuffer);
    }

    public static String translateObjectQuery(String query, PersistenceMetaData pmd, ConnectionProvider provider) throws Exception {
        return QueryTranslator.translateQuery(query, pmd, provider, null);
    }

    private static void processOrder(String order, PersistenceMetaData pmd, ConnectionProvider provider, Map imports, Set tables, StringBuffer orderBuffer, StringBuffer fromBuffer, StringBuffer selectBuffer) throws Exception {
        if (order == null || order.trim().equals("")) {
            return;
        }
        Stack<PersistenceMetaData> stack = new Stack<PersistenceMetaData>();
        stack.push(pmd);
        Vector components = QueryTranslator.parseQuery(order);
        QueryTranslator.processOrder(components, 0, components.size(), provider, imports, stack, new HashSet(tables), orderBuffer, fromBuffer, selectBuffer);
    }

    private static void processOrder(Vector components, int start, int end, ConnectionProvider provider, Map imports, Stack stack, Set tables, StringBuffer orderBuffer, StringBuffer fromBuffer, StringBuffer selectBuffer) throws Exception {
        end = Math.min(end, components.size());
        for (int x = start; x < end; ++x) {
            String component = (String)components.get(x);
            try {
                if (component.equals(" ")) {
                    orderBuffer.append(" ");
                    continue;
                }
                if (component.equals(",")) {
                    orderBuffer.append(",");
                    continue;
                }
                if (component.equals(".")) {
                    orderBuffer.append(" ");
                    continue;
                }
                if (component.equals("ascending")) {
                    orderBuffer.append("ASC");
                    continue;
                }
                if (component.equals("descending")) {
                    orderBuffer.append("DESC");
                    continue;
                }
                PersistenceMetaData pmd = null;
                String variable = null;
                if (x >= end - 1 || QueryTranslator.nextIsMethod(x, end, components) || QueryTranslator.isSpaceChar(components.get(x + 1))) {
                    pmd = QueryTranslator.getPersistenceMetaDataContainingVariable(components, x, imports, stack);
                } else {
                    pmd = QueryTranslator.getPersistenceMetaDataByName(component, imports, stack);
                    if (pmd != null) {
                        while (x < end - 1 && (QueryTranslator.isSpaceChar(components.get(++x)) || QueryTranslator.isDot(components.get(x)))) {
                        }
                    } else {
                        pmd = QueryTranslator.getPersistenceMetaDataContainingVariable(components, x, imports, stack);
                    }
                }
                variable = (String)components.get(x);
                if (pmd == null) {
                    throw new Exception("JSQL: Can not process " + variable + " in order definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components));
                }
                PersistenceMetaData relationPersistenceMetaData = pmd.getRelationPersistenceMetaData(variable);
                if (relationPersistenceMetaData == null) {
                    if (!selectBuffer.toString().trim().equals("")) {
                        selectBuffer.append(", ");
                    }
                    String name = " JSQLOA_" + orderBuffer.length();
                    selectBuffer.append(QueryTranslator.getTableName(pmd, provider));
                    selectBuffer.append(".");
                    String fieldName = pmd.getFieldNameForJavaField(variable, provider);
                    if (fieldName == null) {
                        fieldName = pmd.getFieldNameForJavaField(QueryTranslator.getDependentObjectVariableName(components, x), provider);
                        while (x < end - 1 && (QueryTranslator.isSpaceChar(components.get(++x)) || QueryTranslator.isDot(components.get(x)))) {
                        }
                    }
                    selectBuffer.append(fieldName);
                    selectBuffer.append(" AS ");
                    selectBuffer.append(name);
                    orderBuffer.append(name);
                    continue;
                }
                if (!QueryTranslator.nextNonWhiteSpaceIsDot(x, end, components)) continue;
                String multiplicity = pmd.getRelationMultiplicity(variable);
                boolean backwardReference = pmd.isBackwardReference(variable);
                if ("Many to many".equals(multiplicity)) {
                    throw new Exception("JSQL: Can not process " + variable + " in order definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components) + " because it si not allowed to use 'many to many' relation in a order clause!");
                }
                if ("One to many".equals(multiplicity) && !backwardReference) {
                    throw new Exception("JSQL: Can not process " + variable + " in order definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components) + " because it is not allowed to navigate forwards through a 'one to many' relation in a order clause!");
                }
                if ("Many to one".equals(multiplicity) && backwardReference) {
                    throw new Exception("JSQL: Can not process " + variable + " in order definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components) + " because it is not allowed to navigate backwards through a 'many to one' relation in a order clause!");
                }
                String[][] collumnPairs = pmd.getRelationColomnPairs(variable, provider);
                String tableName = relationPersistenceMetaData.getTableName(provider);
                if (!tables.contains(tableName)) {
                    tables.add(tableName);
                    fromBuffer.insert(0, "( ");
                    fromBuffer.append(" LEFT OUTER JOIN ");
                    fromBuffer.append(QueryTranslator.getTableName(relationPersistenceMetaData, provider));
                    fromBuffer.append(" ON (");
                    for (int i = 0; i < collumnPairs.length; ++i) {
                        if (i > 0) {
                            fromBuffer.append(" AND ");
                        }
                        fromBuffer.append(collumnPairs[i][1]);
                        fromBuffer.append(" = ");
                        fromBuffer.append(collumnPairs[i][0]);
                    }
                    fromBuffer.append(" )) ");
                    tables.add(tableName);
                }
                int y = x = QueryTranslator.getIndexNextDot(x, end, components) + 1;
                while (++y < end && !((String)components.get(y)).equals(",")) {
                }
                stack.push(relationPersistenceMetaData);
                QueryTranslator.processOrder(components, x, Math.min(y, components.size()), provider, imports, stack, tables, orderBuffer, fromBuffer, selectBuffer);
                x = y - 1;
                stack.pop();
                continue;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().startsWith("JSQL")) {
                    throw e;
                }
                e.printStackTrace();
                throw new Exception("JSQL: Error in order declaration near " + QueryTranslator.getQueryFragmentNearPointer(x, components));
            }
        }
    }

    private static String translateQuery(String query, PersistenceMetaData pmd, ConnectionProvider provider, Map imports) throws Exception {
        if (query == null || query.trim().equals("")) {
            return null;
        }
        Stack<PersistenceMetaData> stack = new Stack<PersistenceMetaData>();
        HashMap aliases = new HashMap();
        stack.push(pmd);
        Vector components = QueryTranslator.parseQuery(query);
        StringBuffer resultBuffer = new StringBuffer();
        QueryTranslator.translateQuery(components, 0, components.size(), provider, imports, stack, aliases, resultBuffer);
        return resultBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StringBuffer translateQuery(Vector components, int start, int end, ConnectionProvider provider, Map imports, Stack stack, Map aliases, StringBuffer result) throws Exception {
        end = Math.min(end, components.size());
        int x = start;
        while (true) {
            block76: {
                if (x >= end) {
                    return result;
                }
                String component = (String)components.get(x);
                try {
                    String variable;
                    PersistenceMetaData pmd;
                    block78: {
                        block79: {
                            block77: {
                                if (component.startsWith("###")) {
                                    result.append(component.substring(3));
                                    break block76;
                                }
                                if (component.equals(".")) {
                                    result.append(".");
                                    break block76;
                                }
                                if (component.equals("&")) {
                                    String next;
                                    if (x < end && (next = (String)components.get(x + 1)).equals("&")) {
                                        ++x;
                                    }
                                    result.append("AND");
                                    if (x < end && !(next = (String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (component.equals("|")) {
                                    String next;
                                    if (x < end && (next = (String)components.get(x + 1)).equals("|")) {
                                        ++x;
                                    }
                                    result.append("OR");
                                    if (x < end && !(next = (String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (QueryTranslator.isAS(x, components)) {
                                    result.append(" AS ");
                                    x = QueryTranslator.getIndexNextNonSpaceChar(x + 1, end, components);
                                    result.append(components.get(x));
                                    break block76;
                                }
                                if (QueryTranslator.isNULL(component)) {
                                    result.append("NULL");
                                    break block76;
                                }
                                if (component.equalsIgnoreCase("true") || component.equalsIgnoreCase("false")) {
                                    String type = provider.getDBMapping().getSQLDefinition("boolean");
                                    if (type.indexOf("CHAR") >= 0 || type.indexOf("STRING") >= 0) {
                                        result.append("'" + (component.equalsIgnoreCase("true") ? "true" : "false") + "'");
                                        break block76;
                                    }
                                    if (type.indexOf("BIT") >= 0 || type.indexOf("INT") >= 0 || type.indexOf("NUM") >= 0 || type.indexOf("DEC") >= 0) {
                                        result.append(component.equalsIgnoreCase("true") ? "1" : "0");
                                        break block76;
                                    } else {
                                        result.append(component);
                                    }
                                    break block76;
                                }
                                if (component.equals("!")) {
                                    if (x < end && ((String)components.get(x + 1)).equals("=")) {
                                        result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(++x, end, components) ? " IS NOT " : "<>");
                                    } else {
                                        result.append("NOT");
                                    }
                                    if (x < end && !((String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (component.equals("=")) {
                                    if (x < end && ((String)components.get(x + 1)).equals("=")) {
                                        ++x;
                                    }
                                    result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(x, end, components) ? " IS " : "=");
                                    if (x < end && !((String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (component.equals("<")) {
                                    if (x < end && ((String)components.get(x + 1)).equals("=")) {
                                        result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(++x, end, components) ? " IS " : "<=");
                                    } else if (x < end && ((String)components.get(x + 1)).equals(">")) {
                                        result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(++x, end, components) ? " IS NOT " : "<>");
                                    } else {
                                        result.append("<");
                                    }
                                    if (x < end && !((String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (component.equals(">")) {
                                    if (x < end && ((String)components.get(x + 1)).equals("=")) {
                                        result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(++x, end, components) ? " IS NULL OR NOT " : ">=");
                                    } else {
                                        result.append(QueryTranslator.nextNonWhiteSpaceIsNULL(x, end, components) ? " IS NOT " : ">");
                                    }
                                    if (x < end && !((String)components.get(x + 1)).equals(" ")) {
                                        result.append(" ");
                                    }
                                    break block76;
                                }
                                if (component.startsWith(variablePrefix)) {
                                    result.append(" <");
                                    result.append(component);
                                    while (x < end - 1 && !QueryTranslator.isSpaceChar(components.get(x + 1)) && !QueryTranslator.isRightBracket(components.get(x + 1))) {
                                        result.append(components.get(++x));
                                    }
                                    result.append("?>");
                                    break block76;
                                }
                                if (QueryTranslator.isDelimiter(component)) {
                                    result.append(component);
                                    break block76;
                                }
                                if (QueryTranslator.isNumber(component)) {
                                    result.append(component);
                                    break block76;
                                }
                                if (QueryTranslator.isStartOfQuote(component)) {
                                    result.append(component);
                                    while (!QueryTranslator.isEndOfQuote(component) && x < end) {
                                        component = (String)components.get(++x);
                                        result.append(component);
                                    }
                                    break block76;
                                }
                                if (QueryTranslator.isOperand(components, x, start, end)) {
                                    if (component.trim().equalsIgnoreCase("LIKE") && !QueryTranslator.getSearchStringEscape(provider).equals("\\")) {
                                        int from = QueryTranslator.openingBracket(x, end, components) + 1;
                                        int until = QueryTranslator.closingBracket(from, end, components);
                                        result.append(component.toUpperCase());
                                        while (++x < from) {
                                            result.append(components.get(x));
                                        }
                                        result.append(QueryTranslator.getReEscapedLikeClause(components, from, until, provider));
                                        x = until;
                                        break block76;
                                    }
                                    if (operands.containsKey(component)) {
                                        result.append(operands.get(component));
                                        break block76;
                                    } else {
                                        result.append(component.toUpperCase());
                                    }
                                    break block76;
                                }
                                if (QueryTranslator.isFunction(components, x, start, end)) {
                                    if (functions.containsKey(component)) {
                                        result.append(functions.get(component));
                                        break block76;
                                    } else {
                                        result.append(component.toUpperCase());
                                    }
                                    break block76;
                                }
                                pmd = null;
                                variable = null;
                                if (QueryTranslator.previousInstructionWasFrom(x, start, components) || x < end - 1 && !QueryTranslator.nextIsMethod(x, end, components) && !QueryTranslator.isSpaceChar(components.get(x + 1))) break block77;
                                pmd = QueryTranslator.getPersistenceMetaDataContainingVariable(components, x, imports, stack);
                                break block78;
                            }
                            pmd = QueryTranslator.getPersistenceMetaDataByName(component, imports, stack);
                            if (pmd == null) break block79;
                            if (QueryTranslator.nextNonWhiteSpaceIsDot(x, end, components)) {
                                while (x < end - 1 && (QueryTranslator.isSpaceChar(components.get(++x)) || QueryTranslator.isDot(components.get(x)))) {
                                }
                                break block78;
                            } else {
                                result.append(QueryTranslator.aliasTableName(QueryTranslator.getTableName(pmd, provider), aliases));
                                break block76;
                            }
                        }
                        pmd = QueryTranslator.getPersistenceMetaDataContainingVariable(components, x, imports, stack);
                    }
                    if (pmd == null) {
                        result.append(" <?" + component);
                        while (!(x >= end - 1 || QueryTranslator.isSpaceChar(components.get(x + 1)) || ",".equals(components.get(x + 1)) || compareOperands.contains(components.get(x + 1)) || QueryTranslator.isRightBracket(components.get(x + 1)))) {
                            result.append(components.get(++x));
                        }
                        result.append("?> ");
                        break block76;
                    }
                    variable = (String)components.get(x);
                    int indexVariableComponent = x;
                    PersistenceMetaData relationPersistenceMetaData = null;
                    if (!pmd.containsJavaVariable(QueryTranslator.getDotExtendedName(components, x))) {
                        relationPersistenceMetaData = pmd.getRelationPersistenceMetaData(variable);
                    }
                    if (relationPersistenceMetaData == null) {
                        int until;
                        String javaFieldName;
                        result.append(QueryTranslator.aliasTableName(QueryTranslator.getTableName(pmd, provider), aliases));
                        result.append(".");
                        if (variable.equals("*")) {
                            result.append("*");
                            break block76;
                        }
                        String fieldName = pmd.getFieldNameForJavaField(variable, provider);
                        if (fieldName == null && (javaFieldName = QueryTranslator.getDotExtendedName(components, x)) != null && (fieldName = pmd.getFieldNameForJavaField(javaFieldName, provider)) != null) {
                            while (x < end - 1 && (QueryTranslator.isSpaceChar(components.get(++x)) || QueryTranslator.isDot(components.get(x)))) {
                            }
                        }
                        if (fieldName == null && (javaFieldName = QueryTranslator.getDependentObjectVariableName(components, x)) != null && (fieldName = pmd.getFieldNameForJavaField(javaFieldName, provider)) != null) {
                            while (x < end - 1 && (QueryTranslator.isSpaceChar(components.get(++x)) || QueryTranslator.isDot(components.get(x)))) {
                            }
                        }
                        result.append(fieldName);
                        if (!QueryTranslator.nextIsMethod(indexVariableComponent, end, components)) break block76;
                        x = QueryTranslator.getIndexNextMethod(indexVariableComponent, end, components);
                        component = (String)components.get(x);
                        if (component.equals("startsWith")) {
                            result.append(" LIKE CONCAT(");
                            int from = QueryTranslator.openingBracket(x, end, components) + 1;
                            until = QueryTranslator.closingBracket(from, end, components);
                            result.append(QueryTranslator.getEscapedLikeClause(components, from, until, provider));
                            result.append(",'%') ");
                            x = until;
                            break block76;
                        } else {
                            if (!component.equals("endsWith")) {
                                throw new Exception("Illigal use of method " + component + " in query near " + QueryTranslator.getQueryFragmentNearPointer(x, components));
                            }
                            result.append(" LIKE CONCAT('%',");
                            int from = QueryTranslator.openingBracket(x, end, components) + 1;
                            until = QueryTranslator.closingBracket(from, end, components);
                            result.append(QueryTranslator.getEscapedLikeClause(components, from, until, provider));
                            result.append(") ");
                            x = until;
                        }
                        break block76;
                    }
                    if (relationPersistenceMetaData == null) break block76;
                    if (QueryTranslator.nextIsMethod(indexVariableComponent, end, components) || QueryTranslator.nextNonWhiteSpaceIsDot(indexVariableComponent, end, components)) {
                        if (QueryTranslator.nextIsMethod(indexVariableComponent, end, components)) {
                            x = QueryTranslator.getIndexNextMethod(indexVariableComponent, end, components);
                            component = (String)components.get(x);
                            if (!component.equals("isEmpty") && !component.equals("contains")) {
                                throw new Exception("JSQL: Error in filter definition near '" + QueryTranslator.getQueryFragmentNearPointer(x, components) + "': Illigal use of method " + component);
                            }
                            if (component.equals("isEmpty")) {
                                result.append(" NOT");
                            }
                        }
                        if (!QueryTranslator.nextIsMethod(indexVariableComponent, end, components)) {
                            x = QueryTranslator.getIndexNextDot(indexVariableComponent, end, components) + 1;
                            int endpoint = QueryTranslator.getIndexObjectNavigationEndPoint(x, end, components);
                            int y = Math.min(Math.min(endpoint + 1, end), components.size());
                            result = QueryTranslator.addRelationalSubquery(pmd, relationPersistenceMetaData, variable, components, x, y, provider, imports, stack, aliases, result);
                            x = endpoint;
                            break block76;
                        }
                        if (QueryTranslator.nextBracketPairContains_1_NonSpaceComponent(x, end, components)) {
                            String alias = QueryTranslator.getFirstNonSpaceComponentContainedInNextBracketPair(x, end, components);
                            int endFirstBracketPair = QueryTranslator.closingBracket(QueryTranslator.openingBracket(x, end, components), end, components);
                            int openingBracket = QueryTranslator.openingBracket(endFirstBracketPair + 1, end, components);
                            int closingBracket = QueryTranslator.closingBracket(openingBracket, end, components);
                            boolean firstAmpersandFound = false;
                            boolean secondAmpersandFound = false;
                            boolean andFound = false;
                            if (!QueryTranslator.fragmentEqualsIgnoreCase(endFirstBracketPair + 1, openingBracket, components, andSymbols)) {
                                throw new Exception("JSQL: Eror in filter definition near '" + QueryTranslator.getQueryFragmentNearPointer(endFirstBracketPair + 1, components) + "': Expected 'AND', 'and' , '&&' or '&'  but found " + QueryTranslator.getFragment(endFirstBracketPair + 1, openingBracket, components));
                            }
                            if (imports == null) {
                                imports = new HashMap();
                            }
                            if (imports.containsKey(alias)) {
                                throw new Exception("JSQL: Eror in filter definition near '" + QueryTranslator.getQueryFragmentNearPointer(endFirstBracketPair, components) + "': Conflicting variable/alias '" + alias + "'");
                            }
                            imports.put(alias, relationPersistenceMetaData);
                            result = QueryTranslator.addRelationalSubquery(pmd, relationPersistenceMetaData, variable, components, openingBracket + 1, closingBracket, provider, imports, stack, aliases, result);
                            imports.remove(alias);
                            x = closingBracket;
                            break block76;
                        } else {
                            int openingBracket = QueryTranslator.openingBracket(x, end, components);
                            int closingBracket = QueryTranslator.closingBracket(openingBracket, end, components);
                            result = QueryTranslator.addRelationalSubquery(pmd, relationPersistenceMetaData, variable, components, openingBracket + 1, closingBracket, provider, imports, stack, aliases, result);
                            x = closingBracket;
                        }
                        break block76;
                    }
                    if ("=".equals(QueryTranslator.getNextNonWhiteSpaceComponent(indexVariableComponent, end, components))) {
                        throw new Exception("JSQL: Object references are not yet supported: " + QueryTranslator.getQueryFragmentNearPointer(x, components));
                    }
                    throw new Exception("JSQL: Error in filter definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components));
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("JSQL")) {
                        throw e;
                    }
                    String message = "JSQL: Error in filter definition near " + QueryTranslator.getQueryFragmentNearPointer(x, components);
                    System.out.println(message);
                    e.printStackTrace();
                    throw new Exception(message);
                }
            }
            ++x;
        }
    }

    private static boolean isAS(int x, Vector components) {
        return (components.get(x).equals("as") || components.get(x).equals("AS")) && x > 0 && QueryTranslator.isSpaceChar(components.get(x - 1)) && x < components.size() && QueryTranslator.isSpaceChar(components.get(x + 1));
    }

    private static StringBuffer addRelationalSubquery(PersistenceMetaData fromPMD, PersistenceMetaData toPMD, String variable, Vector components, int start, int end, ConnectionProvider provider, Map imports, Stack stack, Map aliases, StringBuffer result) throws Exception {
        String multiplicity = fromPMD.getRelationMultiplicity(variable);
        if ("Many to many".equals(multiplicity)) {
            return QueryTranslator.addManyToManySubquery(fromPMD, toPMD, variable, components, start, end, provider, imports, stack, aliases, result);
        }
        return QueryTranslator.addStandardRelationalSubquery(fromPMD, toPMD, variable, components, start, end, provider, imports, stack, aliases, result);
    }

    private static StringBuffer addStandardRelationalSubquery(PersistenceMetaData fromPMD, PersistenceMetaData toPMD, String variable, Vector components, int start, int end, ConnectionProvider provider, Map imports, Stack stack, Map aliases, StringBuffer result) throws Exception {
        String[][] collumnPairs = fromPMD.getRelationColomnPairs(variable, provider);
        String tableName = QueryTranslator.getTableName(toPMD, provider);
        String previousAlias = (String)aliases.get(tableName);
        String newAlias = QueryTranslator.getNewAlias(toPMD, stack, tableName, previousAlias);
        result.append(" EXISTS (SELECT * FROM " + tableName);
        if (newAlias != null) {
            result.append(" AS " + newAlias);
        }
        result.append(" WHERE ");
        for (int i = 0; i < collumnPairs.length; ++i) {
            if (i > 0) {
                result.append(" AND ");
            }
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairs[i][1], aliases));
            result.append(" = ");
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairs[i][0], newAlias));
        }
        if (!QueryTranslator.containsOnlySpaceChars(components, start, end)) {
            result.append(" AND ( ");
            stack.push(toPMD);
            if (newAlias != null) {
                aliases.put(tableName, newAlias);
            }
            result = QueryTranslator.translateQuery(components, start, end, provider, imports, stack, aliases, result);
            stack.pop();
            if (newAlias != null) {
                aliases.remove(tableName);
            }
            if (previousAlias != null) {
                aliases.put(tableName, previousAlias);
            }
            result.append(" ) ");
        }
        result.append(" ) ");
        return result;
    }

    private static String aliasTableName(String name, Map aliases) {
        if (aliases == null || aliases.isEmpty()) {
            return name;
        }
        if (aliases.containsKey(name)) {
            return (String)aliases.get(name);
        }
        return name;
    }

    private static Object aliasTableName(String name, String alias) {
        if (alias == null || alias.trim().equals("")) {
            return name;
        }
        return alias;
    }

    private static String aliasTableNamePartInColumn(String name, Map aliases) {
        if (aliases == null || aliases.isEmpty()) {
            return name;
        }
        int indx = name.lastIndexOf(46);
        if (indx < 0 && aliases.containsKey(name)) {
            return (String)aliases.get(name);
        }
        if (indx > 0 && aliases.containsKey(name.substring(0, indx))) {
            return (String)aliases.get(name.substring(0, indx)) + name.substring(indx);
        }
        return name;
    }

    private static Object aliasTableNamePartInColumn(String name, String alias) {
        if (alias == null || alias.trim().equals("")) {
            return name;
        }
        int indx = name.lastIndexOf(46);
        if (indx < 0) {
            return alias;
        }
        return alias + name.substring(indx);
    }

    private static String getNewAlias(PersistenceMetaData toPMD, Stack stack, String tableName, String previousAlias) {
        if (stack.contains(toPMD)) {
            if (previousAlias == null) {
                return tableName.replace('.', '_') + "_TA" + 1;
            }
            int x = Integer.parseInt(previousAlias.substring(previousAlias.length() - 1)) + 1;
            return tableName.replace('.', '_') + "_TA" + x;
        }
        return null;
    }

    private static boolean containsOnlySpaceChars(Vector components, int start, int end) {
        boolean empty = true;
        for (int x = start; x < end && x < components.size() && empty; ++x) {
            if (QueryTranslator.isSpaceChar(components.get(x))) continue;
            empty = false;
        }
        return empty;
    }

    private static StringBuffer addManyToManySubquery(PersistenceMetaData fromPMD, PersistenceMetaData toPMD, String variable, Vector components, int start, int end, ConnectionProvider provider, Map imports, Stack stack, Map aliases, StringBuffer result) throws Exception {
        String[][] collumnPairsToAssociatedTable = fromPMD.getManyToManyColomnPairs(variable, provider, "TAT");
        String[][] collumnPairsFromAssociatedTable = fromPMD.getManyToManyColomnPairs(variable, provider, "FAT");
        result.append(" EXISTS (SELECT * FROM ");
        result.append(provider.getPrefix() + fromPMD.getAssociationTableName(variable, provider));
        result.append(" WHERE ");
        for (int i = 0; i < collumnPairsToAssociatedTable.length; ++i) {
            if (i > 0) {
                result.append(" AND ");
            }
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairsToAssociatedTable[i][1], aliases));
            result.append(" = ");
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairsToAssociatedTable[i][0], aliases));
        }
        String tableName = QueryTranslator.getTableName(toPMD, provider);
        String previousAlias = (String)aliases.get(tableName);
        String newAlias = QueryTranslator.getNewAlias(toPMD, stack, tableName, previousAlias);
        result.append(" AND EXISTS (SELECT * FROM " + tableName);
        if (newAlias != null) {
            result.append(" AS " + newAlias);
        }
        result.append(" WHERE ");
        for (int i = 0; i < collumnPairsFromAssociatedTable.length; ++i) {
            if (i > 0) {
                result.append(" AND ");
            }
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairsFromAssociatedTable[i][1], newAlias));
            result.append(" = ");
            result.append(QueryTranslator.aliasTableNamePartInColumn(collumnPairsFromAssociatedTable[i][0], aliases));
        }
        if (!QueryTranslator.containsOnlySpaceChars(components, start, end)) {
            result.append(" AND ( ");
            stack.push(toPMD);
            if (newAlias != null) {
                aliases.put(tableName, newAlias);
            }
            result = QueryTranslator.translateQuery(components, start, end, provider, imports, stack, aliases, result);
            stack.pop();
            if (newAlias != null) {
                aliases.remove(tableName);
            }
            if (previousAlias != null) {
                aliases.put(tableName, previousAlias);
            }
            result.append(" ) ");
        }
        result.append(" ) ) ");
        return result;
    }

    private static PersistenceMetaData getPersistenceMetaDataByName(String name, Map imports, Stack stack) {
        if (imports != null && imports.containsKey(name)) {
            return (PersistenceMetaData)imports.get(name);
        }
        for (int i = stack.size() - 1; i >= 0; --i) {
            PersistenceMetaData pmd = (PersistenceMetaData)stack.get(i);
            if (!pmd.getBusinessObjectName().equals(name)) continue;
            return pmd;
        }
        return null;
    }

    private static Object getEscapedLikeClause(Vector components, int from, int until, ConnectionProvider provider) {
        String quote = (String)components.get(from);
        int f = from + 1;
        while (f < until) {
            quote = quote + (String)components.get(f++);
        }
        if (quote.indexOf(95) < 0 && quote.indexOf(37) < 0) {
            return quote;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < quote.length(); ++i) {
            if (quote.charAt(i) == '_' || quote.charAt(i) == '%') {
                buffer.append(QueryTranslator.getSearchStringEscape(provider));
            }
            buffer.append(quote.charAt(i));
        }
        return buffer.toString();
    }

    private static Object getReEscapedLikeClause(Vector components, int from, int until, ConnectionProvider provider) {
        String quote = (String)components.get(from);
        int f = from + 1;
        while (f < until) {
            quote = quote + (String)components.get(f++);
        }
        if (quote.indexOf("\\_") < 0 && quote.indexOf("\\%") < 0) {
            return quote;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < quote.length() - 1; ++i) {
            if (quote.charAt(i) == '\\') {
                if (i < quote.length() - 3 && quote.charAt(i + 1) == '\\' && (quote.charAt(i + 2) == '_' || quote.charAt(i + 2) == '%')) {
                    buffer.append(quote.charAt(i++));
                    continue;
                }
                if (quote.charAt(i + 1) == '_' || quote.charAt(i + 1) == '%') {
                    buffer.append(QueryTranslator.getSearchStringEscape(provider));
                    continue;
                }
                buffer.append(quote.charAt(i));
                continue;
            }
            buffer.append(quote.charAt(i));
        }
        return buffer.toString();
    }

    private static String getSearchStringEscape(ConnectionProvider provider) {
        return provider.getSearchStringEscape();
    }

    private static PersistenceMetaData getPersistenceMetaDataContainingVariable(Vector components, int pointer, Map imports, Stack stack) {
        String variableName = (String)components.get(pointer);
        String extendedVariableName = null;
        String candidateDOName = null;
        boolean initialisedCandidateDO = false;
        boolean initialisedExtendedVariableName = false;
        for (int i = stack.size() - 1; i >= 0; --i) {
            PersistenceMetaData pmd = (PersistenceMetaData)stack.get(i);
            if (pmd.containsJavaVariable(variableName)) {
                return pmd;
            }
            if (!initialisedCandidateDO) {
                candidateDOName = QueryTranslator.getDependentObjectVariableName(components, pointer);
                initialisedCandidateDO = true;
            }
            if (candidateDOName != null && pmd.containsJavaVariable(candidateDOName)) {
                return pmd;
            }
            if (!initialisedExtendedVariableName) {
                extendedVariableName = QueryTranslator.getDotExtendedName(components, pointer);
                initialisedExtendedVariableName = true;
            }
            if (extendedVariableName == null || !pmd.containsJavaVariable(extendedVariableName)) continue;
            return pmd;
        }
        if (imports != null) {
            for (PersistenceMetaData pmd : imports.values()) {
                if (pmd.containsJavaVariable(variableName)) {
                    return pmd;
                }
                if (!initialisedCandidateDO) {
                    candidateDOName = QueryTranslator.getDependentObjectVariableName(components, pointer);
                    initialisedCandidateDO = true;
                }
                if (candidateDOName != null && pmd.containsJavaVariable(candidateDOName)) {
                    return pmd;
                }
                if (!initialisedExtendedVariableName) {
                    extendedVariableName = QueryTranslator.getDotExtendedName(components, pointer);
                    initialisedExtendedVariableName = true;
                }
                if (extendedVariableName == null || !pmd.containsJavaVariable(extendedVariableName)) continue;
                return pmd;
            }
        }
        return null;
    }

    private static String getDependentObjectVariableName(Vector components, int pointer) {
        if (QueryTranslator.nextNonWhiteSpaceIsDot(pointer, components.size(), components) && !QueryTranslator.nextIsMethod(pointer + 1, components.size(), components)) {
            String p1 = (String)components.get(pointer);
            int x = QueryTranslator.getIndexNextNonSpaceChar(QueryTranslator.getIndexNextDot(pointer + 1, components.size(), components) + 1, components.size(), components);
            if (x < 0) {
                return null;
            }
            String p2 = (String)components.get(x);
            return Character.toLowerCase(p1.charAt(0)) + p1.substring(1) + Character.toUpperCase(p2.charAt(0)) + p2.substring(1);
        }
        return null;
    }

    private static String getDotExtendedName(Vector components, int pointer) {
        if (QueryTranslator.nextNonWhiteSpaceIsDot(pointer, components.size(), components) && !QueryTranslator.nextIsMethod(pointer + 1, components.size(), components) && !QueryTranslator.nextNonWhiteSpaceIsDot(pointer + 2, components.size(), components)) {
            String p1 = (String)components.get(pointer);
            int x = QueryTranslator.getIndexNextNonSpaceChar(QueryTranslator.getIndexNextDot(pointer + 1, components.size(), components) + 1, components.size(), components);
            if (x < 0) {
                return null;
            }
            return p1 + "." + (String)components.get(x);
        }
        return null;
    }

    private static String getTableName(PersistenceMetaData pmd, ConnectionProvider provider) {
        return provider.getPrefix() + pmd.getTableName(provider);
    }

    private static boolean fragmentEqualsIgnoreCase(int _start, int _end, Vector components, String[] values) {
        String result = QueryTranslator.getFragment(_start, _end, components).trim();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !result.equals(values[i].trim())) continue;
            return true;
        }
        return false;
    }

    private static String getFragment(int _start, int _end, Vector components) {
        StringBuffer buffer = new StringBuffer();
        for (int i = _start; i < _end; ++i) {
            buffer.append(components.get(i));
        }
        return buffer.toString();
    }

    private static boolean previousInstructionWasFrom(int pointer, int underborder, Vector components) {
        for (int i = pointer; i >= underborder; --i) {
            if (!operands.containsKey(components.get(i))) continue;
            return ((String)components.get(i)).equals("FROM") || ((String)components.get(i)).equals("from");
        }
        return true;
    }

    private static boolean nextBracketPairIsEmpty(int _start, int _end, Vector components) {
        int openingBracket = QueryTranslator.openingBracket(_start, _end, components);
        int closingBracket = QueryTranslator.closingBracket(openingBracket, _end, components);
        for (int i = openingBracket + 1; i < closingBracket; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return false;
        }
        return true;
    }

    private static String getFirstNonSpaceComponentContainedInNextBracketPair(int _start, int _end, Vector components) {
        int openingBracket = QueryTranslator.openingBracket(_start, _end, components);
        int closingBracket = QueryTranslator.closingBracket(openingBracket, _end, components);
        for (int i = openingBracket + 1; i < closingBracket; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return (String)components.get(i);
        }
        return null;
    }

    private static boolean nextBracketPairContains_1_NonSpaceComponent(int _start, int _end, Vector components) {
        int openingBracket = QueryTranslator.openingBracket(_start, _end, components);
        int closingBracket = QueryTranslator.closingBracket(openingBracket, _end, components);
        boolean firstNonSpaceFound = false;
        for (int i = openingBracket + 1; i < closingBracket; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            if (firstNonSpaceFound) {
                return false;
            }
            firstNonSpaceFound = true;
        }
        return firstNonSpaceFound;
    }

    private static int getIndexObjectNavigationEndPoint(int start, int end, Vector components) {
        int from = Math.max(0, start);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.nextIsMethod(i, until, components)) {
                if (QueryTranslator.nextBracketPairContains_1_NonSpaceComponent(i, until, components)) {
                    i = QueryTranslator.closingBracket(QueryTranslator.openingBracket(i, until, components), until, components);
                    return QueryTranslator.closingBracket(QueryTranslator.openingBracket(i, until, components), until, components);
                }
                return QueryTranslator.closingBracket(QueryTranslator.openingBracket(i, until, components), until, components);
            }
            if (compareOperands.contains(components.get(i))) {
                for (int y = i + 1; y < until; ++y) {
                    if (QueryTranslator.isStartOfQuote(components.get(y))) {
                        y = QueryTranslator.getIndexEndOfQuote(y, until, components);
                    }
                    if (!andOperands.contains(components.get(y)) && !orOperands.contains(components.get(y)) && !QueryTranslator.isRightBracket(components.get(y))) continue;
                    return y - 1;
                }
                return until;
            }
            if (((String)components.get(i)).equalsIgnoreCase("BETWEEN")) {
                boolean andEncountered = false;
                for (int y = i + 1; y < until; ++y) {
                    if (QueryTranslator.isStartOfQuote(components.get(y))) {
                        y = QueryTranslator.getIndexEndOfQuote(y, until, components);
                        if (andEncountered) {
                            return y;
                        }
                    }
                    if (andOperands.contains(components.get(y))) {
                        andEncountered = true;
                        if (!andOperands.contains(components.get(y + 1))) continue;
                        ++y;
                        continue;
                    }
                    if (QueryTranslator.isSpaceChar(components.get(y)) || !andEncountered) continue;
                    return y;
                }
                return until;
            }
            if (!((String)components.get(i)).equalsIgnoreCase("IN")) continue;
            return QueryTranslator.closingBracket(QueryTranslator.openingBracket(i, until, components), until, components);
        }
        return until;
    }

    private static int openingBracket(int _start, int _end, Vector components) {
        int pointer;
        int end = Math.min(_end, components.size());
        for (pointer = _start; pointer < end && !((String)components.get(pointer)).equals("("); ++pointer) {
        }
        return pointer;
    }

    private static int closingBracket(int _start, int _end, Vector components) {
        int counter = 1;
        int pointer = _start;
        int end = Math.min(_end, components.size());
        while (counter > 0 && pointer < end) {
            String component;
            if (QueryTranslator.isStartOfQuote(component = (String)components.get(++pointer))) {
                while (pointer < end && !QueryTranslator.isEndOfQuote((String)components.get(pointer++))) {
                }
                component = (String)components.get(pointer);
            }
            if (component.equals("(")) {
                ++counter;
                continue;
            }
            if (!component.equals(")")) continue;
            --counter;
        }
        return pointer;
    }

    private static String getQueryFragmentNearPointer(int pointer, Vector components) {
        int start = Math.max(0, pointer - 8);
        int end = Math.min(components.size(), pointer + 8);
        StringBuffer buffer = new StringBuffer();
        for (int i = start; i < end; ++i) {
            buffer.append(components.get(i));
        }
        return buffer.toString();
    }

    private static boolean nextNonWhiteSpaceIsDot(int start, int end, Vector components) {
        int from = Math.max(0, start + 1);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return QueryTranslator.isDot(components.get(i));
        }
        return false;
    }

    private static boolean nextNonWhiteSpaceIsLeftBracket(int start, int end, Vector components) {
        int from = Math.max(0, start + 1);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return QueryTranslator.isLeftBracket(components.get(i));
        }
        return false;
    }

    private static String getNextNonWhiteSpaceComponent(int start, int end, Vector components) {
        int from = Math.max(0, start + 1);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return (String)components.get(i);
        }
        return null;
    }

    private static boolean previousNonWhiteSpaceIsDot(int start, int end, Vector components) {
        int from = Math.min(components.size(), start - 1);
        int until = Math.max(0, end);
        for (int i = from; i >= until; --i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return QueryTranslator.isDot(components.get(i));
        }
        return false;
    }

    private static boolean nextNonWhiteSpaceIsNULL(int start, int end, Vector components) {
        int from = Math.max(0, start + 1);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return QueryTranslator.isNULL(components.get(i));
        }
        return false;
    }

    private static boolean isNULL(Object object) {
        return String.valueOf(object).equalsIgnoreCase("null");
    }

    private static int getIndexNextDot(int start, int end, Vector components) {
        int from = Math.max(0, start);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (!QueryTranslator.isDot(components.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static int getIndexNextNonSpaceChar(int start, int end, Vector components) {
        int from = Math.max(0, start);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isSpaceChar(components.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static boolean nextIsMethod(int start, int end, Vector components) {
        return QueryTranslator.getIndexNextMethod(start, end, components) >= 0;
    }

    private static int getIndexNextMethod(int start, int end, Vector components) {
        int from = Math.max(0, start + 1);
        int until = Math.min(components.size(), end);
        for (int i = from; i < until; ++i) {
            if (QueryTranslator.isMethodName(components.get(i))) {
                return i;
            }
            if (QueryTranslator.isSpaceChar(components.get(i)) || QueryTranslator.isDot(components.get(i))) continue;
            return -1;
        }
        return -1;
    }

    private static int getIndexEndOfQuote(int start, int end, Vector components) {
        int x;
        int from = Math.max(0, start);
        int until = Math.min(components.size(), end) - 1;
        int n = x = ((String)components.get(from)).length() == 1 ? from + 1 : from;
        while (x < until && !QueryTranslator.isEndOfQuote(components.get(x))) {
            ++x;
        }
        return x;
    }

    private static boolean isSpaceChar(Object object) {
        return QueryTranslator.isSpaceChar((String)object);
    }

    private static boolean isSpaceChar(String string) {
        if (string == null || string.length() != 1) {
            return false;
        }
        return Character.isSpaceChar(string.charAt(0));
    }

    private static boolean isDot(Object object) {
        return QueryTranslator.isDot((String)object);
    }

    private static boolean isDot(String string) {
        return string != null && string.equals(".");
    }

    private static boolean isLeftBracket(Object object) {
        return QueryTranslator.isLeftBracket((String)object);
    }

    private static boolean isLeftBracket(String string) {
        return string != null && string.equals("(");
    }

    private static boolean isRightBracket(Object object) {
        return QueryTranslator.isRightBracket((String)object);
    }

    private static boolean isRightBracket(String string) {
        return string != null && string.equals(")");
    }

    private static boolean isMethodName(Object object) {
        return methodNames.contains(object);
    }

    private static boolean isDelimiter(Object object) {
        return QueryTranslator.isDelimiter((String)object);
    }

    private static boolean isDelimiter(String string) {
        return delimeters.indexOf(string) > -1;
    }

    private static boolean isOperand(Object object) {
        return operands.containsKey(object) || operands.containsValue(object);
    }

    private static boolean isOperand(Vector components, int pointer, int lowerLimit, int upperLimit) {
        return QueryTranslator.isOperand(components.get(pointer)) && !QueryTranslator.nextNonWhiteSpaceIsDot(pointer, upperLimit + 2, components) && !QueryTranslator.previousNonWhiteSpaceIsDot(pointer, lowerLimit - 2, components);
    }

    private static boolean isFunction(Object object) {
        return functions.containsKey(object) || functions.containsValue(object);
    }

    private static boolean isFunction(Vector components, int pointer, int lowerLimit, int upperLimit) {
        return QueryTranslator.isFunction(components.get(pointer)) && QueryTranslator.nextNonWhiteSpaceIsLeftBracket(pointer, upperLimit + 2, components) && !QueryTranslator.previousNonWhiteSpaceIsDot(pointer, lowerLimit - 2, components);
    }

    private static boolean isStartOfQuote(Object object) {
        return QueryTranslator.isStartOfQuote((String)object);
    }

    private static boolean isStartOfQuote(String string) {
        return string.startsWith("'");
    }

    private static boolean isEndOfQuote(Object object) {
        return QueryTranslator.isEndOfQuote((String)object);
    }

    private static boolean isEndOfQuote(String string) {
        return string.endsWith("'");
    }

    private static boolean isNumber(Object object) {
        return QueryTranslator.isNumber((String)object);
    }

    private static boolean isNumber(String string) {
        int dotCount = 0;
        for (int x = 0; x < string.length(); ++x) {
            if (Character.isDigit(string.charAt(x))) continue;
            if (string.charAt(x) == '.' && dotCount == 0) {
                ++dotCount;
                continue;
            }
            if (x == 0 && (string.charAt(x) == '+' || string.charAt(x) == '-')) continue;
            return false;
        }
        return true;
    }

    private static Vector parseQuery(String query) {
        StringTokenizer tokenizer = new StringTokenizer(query, delimeters, true);
        Vector<String> vector = new Vector<String>();
        block0: while (tokenizer.hasMoreTokens()) {
            String sPart = tokenizer.nextToken();
            if (!sPart.startsWith("'") && !sPart.startsWith("\"")) {
                vector.add(sPart);
                continue;
            }
            if (sPart.startsWith("'") && !QueryTranslator.isEndOfQuote(sPart, "'", true) || sPart.startsWith("\"") && !QueryTranslator.isEndOfQuote(sPart, "\"", true)) {
                StringBuffer sQuoted = new StringBuffer(sPart);
                String t = sPart.substring(0, 1);
                while (tokenizer.hasMoreTokens()) {
                    sPart = tokenizer.nextToken();
                    sQuoted.append(sPart);
                    if (!QueryTranslator.isEndOfQuote(sPart, t, false)) continue;
                    String quote = t.equals("'") ? sQuoted.toString() : "'" + QueryTranslator.escapeSingleQuotes(sQuoted.substring(1, sQuoted.length() - 1)) + "'";
                    quote = QueryTranslator.replaceEscapeChars(quote, t);
                    vector.add(quote);
                    continue block0;
                }
                continue;
            }
            if (sPart.startsWith("\"") && sPart.endsWith("\"") && sPart.length() > 1) {
                vector.add("'" + QueryTranslator.escapeSingleQuotes(QueryTranslator.replaceEscapeChars(sPart.substring(1, sPart.length() - 1), "\"")) + "'");
                continue;
            }
            vector.add(sPart);
        }
        return vector;
    }

    private static String escapeSingleQuotes(String string) {
        if (string.indexOf(39) < 0) {
            return string;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\'') {
                buffer.append('\'');
            }
            buffer.append(string.charAt(i));
        }
        return buffer.toString();
    }

    private static String replaceEscapeChars(String quote, String quoteIdentifier) {
        char escape = QueryTranslator.getEscapeChar(quoteIdentifier);
        if (escape == '\'') {
            return quote;
        }
        if (quote.length() == 0 || quote.indexOf(escape) < 0) {
            return quote;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < quote.length(); ++i) {
            if (quote.charAt(i) == escape) {
                if (i + 1 == quote.length()) break;
                if (quote.charAt(i + 1) == escape) {
                    buffer.append(quote.charAt(++i));
                    continue;
                }
                buffer.append(quote.charAt(i));
                continue;
            }
            buffer.append(quote.charAt(i));
        }
        return buffer.toString();
    }

    private static boolean isEndOfQuote(String quote, String quoteIdentifier, boolean quoteIncludesStartQuote) {
        if (quoteIncludesStartQuote && quote.length() == 1) {
            return false;
        }
        if (!quote.endsWith(quoteIdentifier)) {
            return false;
        }
        char escape = QueryTranslator.getEscapeChar(quoteIdentifier);
        int count = 0;
        int start = quoteIncludesStartQuote ? 1 : 0;
        int i = quote.length() - 2;
        while (i >= start && quote.charAt(i) == escape) {
            --i;
            ++count;
        }
        return count % 2 == 0;
    }

    private static char getEscapeChar(String quoteIdentifier) {
        return quoteIdentifier.charAt(0);
    }

    private static String replaceString(String text, String oldValue, String newValue) {
        return QueryTranslator.replaceString(text, oldValue, newValue, 0);
    }

    private static String replaceString(String text, String oldValue, String newValue, int from) {
        int n = text.indexOf(oldValue, from);
        if (n > -1) {
            return QueryTranslator.replaceString(text.substring(0, n) + newValue + text.substring(n + oldValue.length()), oldValue, newValue, n + newValue.length());
        }
        return text;
    }

    private static void main(String[] args) {
        Vector components = QueryTranslator.parseQuery("bla bla");
        for (int i = 0; i < components.size(); ++i) {
            System.out.println(i + " - >>" + components.get(i) + "<< - " + ((String)components.get(i)).equals(","));
        }
        int y = 0;
        while (++y < components.size() && !((String)components.get(y)).equals(",")) {
        }
        System.out.println("index " + y);
    }

    static {
        methodNames.add("startsWith");
        methodNames.add("endsWith");
        methodNames.add("isEmpty");
        methodNames.add("contains");
        andOperands.add("AND");
        andOperands.add("and");
        andOperands.add("&&");
        andOperands.add("&");
        orOperands.add("OR");
        orOperands.add("or");
        orOperands.add("||");
        orOperands.add("|");
        compareOperands.add("=");
        compareOperands.add("==");
        compareOperands.add("!=");
        compareOperands.add(">");
        compareOperands.add("<");
        compareOperands.add("<>");
        compareOperands.add("<=");
        compareOperands.add(">=");
        compareOperands.add("like");
        compareOperands.add("LIKE");
        operands.put("select", "SELECT");
        operands.put("create", "CREATE");
        operands.put("view", "VIEW");
        operands.put("as", "AS");
        operands.put("on", "ON");
        operands.put("drop", "DROP");
        operands.put("is", "IS");
        operands.put("distinct", "DISTINCT");
        operands.put("from", "FROM");
        operands.put("where", "WHERE");
        operands.put("and", "AND");
        operands.put("or", "OR");
        operands.put("on", "ON");
        operands.put("between", "BETWEEN");
        operands.put("as", "AS");
        operands.put("in", "IN");
        operands.put("having", "HAVING");
        operands.put("order", "ORDER");
        operands.put("group", "GROUP");
        operands.put("for", "FOR");
        operands.put("all", "ALL");
        operands.put("by", "BY");
        operands.put("asc", "ASC");
        operands.put("desc", "DESC");
        operands.put("ascending", "ASC");
        operands.put("descending", "DESC");
        operands.put("exists", "EXISTS");
        operands.put("any", "ANY");
        operands.put("all", "ALL");
        operands.put("sum", "SUM");
        operands.put("min", "MIN");
        operands.put("max", "MAX");
        operands.put("avg", "AVG");
        operands.put("abs", "ABS");
        operands.put("count", "COUNT");
        operands.put("like", "LIKE");
        operands.put("not", "NOT");
        operands.put("some", "SOME");
        operands.put("inner", "INNER");
        operands.put("outher", "OUTHER");
        operands.put("join", "JOIN");
        operands.put("union", "UNION");
        operands.put("except", "EXCEPT");
        operands.put("intersect", "INTERSECT");
        operands.put("escape", "ESCAPE");
        functions.put("concat", "CONCAT");
        functions.put("mod", "MOD");
        functions.put("substring", "SUBSTRING");
        functions.put("replace", "REPLACE");
        functions.put("round", "ROUND");
        functions.put("ltrim", "LTRIM");
        functions.put("rtrim", "RTRIM");
        functions.put("trim", "TRIM");
        functions.put("upper", "UPPER");
        functions.put("lower", "LOWER");
        functions.put("length", "LENGTH");
        functions.put("truncate", "TRUNCATE");
        functions.put("ceiling", "CEILING");
        functions.put("floor", "FLOOR");
        functions.put("coalesce", "COALESCE");
        functions.put("year", "YEAR");
        functions.put("quarter", "QUARTER");
        functions.put("month", "MONTH");
        functions.put("week", "WEEK");
        functions.put("day", "DAY");
        functions.put("hour", "HOUR");
        functions.put("minute", "MINUTE");
        functions.put("second", "SECOND");
        functions.put("dayOfYear", "DAYOFYEAR");
        functions.put("dayOfMonth", "DAYOFMONTH");
        functions.put("dayOfWeek", "DAYOFWEEK");
        functions.put("hex", "HEX");
        functions.put("cast", "CAST");
        functions.put("decimal", "DECIMAL");
        functions.put("char", "CHAR");
        functions.put("digits", "DIGITS");
        functions.put("left", "LEFT");
        functions.put("strip", "STRIP");
        functions.put("position", "POSITION");
        functions.put("curdate", "CURDATE");
        functions.put("curtime", "CURTIME");
        functions.put("timestamp", "TIMESTAMP");
        functions.put("zoned", "ZONED");
        functions.put("ifnull", "IFNULL");
        functions.put("nullif", "NULLIF");
    }
}

